import io.kform.AbsolutePath
import io.kform.AbsolutePathFragment
import io.kform.Path
import io.kform.toAbsolutePath

/** [Absolute path][AbsolutePath] wrapper for use from JavaScript. */
@JsExport
@JsName("AbsolutePath")
public open class AbsolutePathJs(path: Any = emptyArray<AbsolutePathFragmentJs>()) : PathJs(path) {
    final override val pathKt: AbsolutePath =
        when (path) {
            is Path -> path.toAbsolutePath()
            is PathJs -> path.pathKt.toAbsolutePath()
            is Array<*> -> AbsolutePath(path.map { (it as AbsolutePathFragmentJs).fragmentKt })
            else -> AbsolutePath(path.toString())
        }

    public override val fragments: Array<Any>
        get() = pathKt.fragments.cachedToJs { it.toJs() }

    public val size: Int = pathKt.size

    public val isRoot: Boolean = pathKt.isRoot

    public val lastFragment: Any? = pathKt.lastFragment?.toJs()

    override fun fragment(index: Int): Any = pathKt[index].toJs()

    public fun hasWildcard(): Boolean = pathKt.hasWildcard()

    public fun hasRecursiveWildcard(): Boolean = pathKt.hasRecursiveWildcard()

    public fun hasAnyWildcard(): Boolean = pathKt.hasAnyWildcard()

    override fun parent(): AbsolutePathJs = AbsolutePathJs(pathKt.parent())

    public override fun append(): PathJs {
        var allAbsolute = true
        val fragmentsKt =
            functionArguments<Any>().map {
                (it as PathFragmentJs).fragmentKt.also { fragmentKt ->
                    if (fragmentKt !is AbsolutePathFragment) {
                        allAbsolute = false
                    }
                }
            }

        @Suppress("UNCHECKED_CAST")
        return if (allAbsolute)
            AbsolutePathJs(
                pathKt.append(*(fragmentsKt as List<AbsolutePathFragment>).toTypedArray())
            )
        else PathJs(pathKt.append(*fragmentsKt.toTypedArray()))
    }

    override fun resolve(): AbsolutePathJs =
        AbsolutePathJs(
            pathKt.resolve(
                *functionArguments<Any>()
                    .map { if (it is PathJs) it.pathKt else Path(it.toString()) }
                    .toTypedArray()
            )
        )

    public fun matches(path: Any): Boolean = pathKt.matches(path.toPathKt())

    public operator fun contains(path: Any): Boolean = pathKt.contains(path.toPathKt())

    public fun relativeTo(path: Any): PathJs = PathJs(pathKt.relativeTo(path.toPathKt()))

    public override fun equals(other: Any?): Boolean =
        when {
            this === other -> true
            other !is PathJs -> false
            else -> pathKt == other.pathKt
        }

    public override fun hashCode(): Int = pathKt.hashCode()

    public companion object {
        /** [Root absolute path][AbsolutePath.ROOT] wrapper for use from JavaScript. */
        @JsStatic public val ROOT: AbsolutePathJs = AbsolutePathJs(AbsolutePath.ROOT)

        /** [Match all absolute path][AbsolutePath.MATCH_ALL] wrapper for use from JavaScript. */
        @JsStatic public val MATCH_ALL: AbsolutePathJs = AbsolutePathJs(AbsolutePath.MATCH_ALL)
    }
}

/**
 * Function which converts an [AbsolutePath] into a wrapped [AbsolutePathJs] object to be used from
 * JavaScript, while caching the conversion in the process.
 */
internal fun AbsolutePath.cachedToJs(): AbsolutePathJs =
    getOrSetFromCache(this) { AbsolutePathJs(this) }
