/** JavaScript's `Object` object. */
private external val Object: dynamic

/**
 * Transforms a JavaScript object into a [Map] with [String] keys, optionally mapping the values in
 * the process.
 */
@Suppress("NON_EXPORTABLE_TYPE")
@JsExport
@JsName("objectToKtMap")
public fun <T, TMapped> jsObjectToMap(
    obj: RecordTs<String, T>?,
    valueMapper: ((value: T) -> TMapped)? = null,
): Map<String, TMapped>? {
    obj ?: return null
    val keys = Object.keys(obj)
    return keys.reduce(
        { map: MutableMap<String, TMapped>, key: String ->
            map[key] =
                valueMapper?.invoke(obj.asDynamic()[key] as T) ?: obj.asDynamic()[key] as TMapped
            map
        },
        LinkedHashMap<String, T>(keys.length as Int),
    ) as Map<String, TMapped>
}

/** Transforms a [Map] into a JavaScript object, optionally mapping the values in the process. */
@Suppress("NON_EXPORTABLE_TYPE")
@JsExport
@JsName("ktMapToObject")
public fun <T, TKey, TMapped> mapToJsObject(
    map: Map<TKey, T>?,
    valueMapper: ((value: T) -> TMapped)? = null,
): RecordTs<String, TMapped>? {
    map ?: return null
    return map.entries.fold(emptyJsObject()) { obj, (key, value) ->
        obj.asDynamic()[key.toString()] = valueMapper?.invoke(value) ?: value
        obj
    }
}
