import io.kform.datatypes.BigDecimal
import io.kform.schemas.BigDecimalSchema

/**
 * Schema representing big decimals. Wraps a [big decimal schema][BigDecimalSchema] for use from
 * JavaScript.
 */
@JsName("bigDecimalSchema")
@JsExport
public fun bigDecimalSchemaJs(options: SchemaOptionsJs<BigDecimal>? = null): SchemaJs<BigDecimal> =
    (if (options?.initialValue != null)
            BigDecimalSchema(
                options.validations?.map { it.validationKt } ?: emptyList(),
                options.initialValue!!,
            )
        else BigDecimalSchema(options?.validations?.map { it.validationKt } ?: emptyList()))
        .cachedToJs()
