import io.kform.validations.NotBlank
import io.kform.validations.NotEmpty
import io.kform.validations.Required

/** [Required] validation wrapper for use from JavaScript. */
@JsExport
@JsName("required")
public fun requiredJs(
    code: String = Required.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Any?> = Required(code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Not empty][NotEmpty] validation wrapper for use from JavaScript. */
@JsExport
@JsName("notEmpty")
public fun notEmptyJs(
    code: String = NotEmpty.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Any> = NotEmpty(code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Not blank][NotBlank] validation wrapper for use from JavaScript. */
@JsExport
@JsName("notBlank")
public fun notBlankJs(
    code: String = NotBlank.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<String> = NotBlank(code, severity.toValidationIssueSeverityKt()).cachedToJs()
