@file:OptIn(DelicateCoroutinesApi::class)

import io.kform.LocatedValidationIssue
import io.kform.Schema
import io.kform.util.convertTableRowIdsToIndices
import io.kform.util.convertTableRowIndicesToIds
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertPathTableRowIndicesToIds(
    path: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<AbsolutePathJs> =
    GlobalScope.cancellablePromise {
        path
            .toPathKt()
            .convertTableRowIndicesToIds(formSchema.toSchemaKt() as Schema<T>, formValue)
            .cachedToJs()
    }

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertPathTableRowIdsToIndices(
    path: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<AbsolutePathJs> =
    GlobalScope.cancellablePromise {
        path
            .toPathKt()
            .convertTableRowIdsToIndices(formSchema.toSchemaKt() as Schema<T>, formValue)
            .cachedToJs()
    }

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertIssueTableRowIndicesToIds(
    issue: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<LocatedValidationIssueJs> =
    GlobalScope.cancellablePromise {
        issue
            .toLocatedValidationIssueKt()
            .convertTableRowIndicesToIds(formSchema.toSchemaKt() as Schema<T>, formValue)
            .cachedToJs()
    }

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertIssuesTableRowIndicesToIds(
    issues: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<Array<LocatedValidationIssueJs>> =
    GlobalScope.cancellablePromise {
        issues
            .toIterableKt<Any, LocatedValidationIssue> { it.toLocatedValidationIssueKt() }
            .convertTableRowIndicesToIds(formSchema.toSchemaKt() as Schema<T>, formValue)
            .map { it.cachedToJs() }
            .toTypedArray()
    }
