import io.kform.TypeInfo

/** [TypeInfo] wrapper for use from JavaScript. */
@JsExport
@JsName("TypeInfo")
public class TypeInfoJs internal constructor(private val typeInfoKt: TypeInfo) {
    public val name: String
        get() = typeInfoKt.name

    public val nullable: Boolean
        get() = typeInfoKt.nullable

    public val arguments: Array<TypeInfoJs>
        get() = typeInfoKt.arguments.cachedToJs { it.cachedToJs() }

    public val restrictions: RecordTs<String, Any?>
        get() = typeInfoKt.restrictions.cachedToJs()

    override fun equals(other: Any?): Boolean =
        when {
            this === other -> true
            other !is TypeInfoJs -> false
            else -> typeInfoKt == other.typeInfoKt
        }

    override fun hashCode(): Int = typeInfoKt.hashCode()

    public override fun toString(): String = typeInfoKt.toString()
}

/**
 * Function which converts a [TypeInfo] into a wrapped [TypeInfoJs] object to be used from
 * JavaScript, while caching the conversion in the process.
 */
internal fun TypeInfo.cachedToJs(): TypeInfoJs = getOrSetFromCache(this) { TypeInfoJs(this) }
