@file:OptIn(ExperimentalJsExport::class, DelicateCoroutinesApi::class)

import io.kform.*
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope

@JsExport
@JsName("validatePath")
public fun validatePathJs(formSchema: Any, path: Any): Nothing? {
    validatePath(formSchema.toSchemaKt(), path.toPathKt())
    return undefined
}

@JsExport
@JsName("validateSchemaValidations")
public fun validateSchemaValidationsJs(formSchema: Any): Nothing? {
    validateSchemaValidations(formSchema.toSchemaKt())
    return undefined
}

@JsExport
@JsName("validateExternalValidations")
public fun validateExternalValidationsJs(
    formSchema: Any,
    externalValidations: RecordTs<String, Array<Any>>,
): Nothing? {
    @Suppress("UNCHECKED_CAST")
    validateExternalValidations(
        formSchema.toSchemaKt(),
        jsObjectToMap(externalValidations) { array -> array.map { it.toValidationKt() } }
            as Map<PathOrString, List<Validation<*>>>,
    )
    return undefined
}

@JsExport
@JsName("isValidPath")
public fun isValidPathJs(formSchema: Any, path: Any): Boolean =
    isValidPath(formSchema.toSchemaKt(), path.toPathKt())

@JsExport
@JsName("schemaInfo")
public fun schemaInfoJs(
    formSchema: Any,
    path: Any = AbsolutePathJs.MATCH_ALL,
): IterableJs<SchemaInfoJs<*>> =
    schemaInfo(formSchema.toSchemaKt(), path.toPathKt()).toIterableJs { it.cachedToJs() }

@JsExport
@JsName("schema")
public fun schemaJs(formSchema: Any, path: Any): SchemaJs<*> =
    schema(formSchema.toSchemaKt(), path.toPathKt()).cachedToJs()

@JsExport
@JsName("valueInfo")
public fun valueInfoJs(
    formSchema: Any,
    formValue: Any?,
    path: Any = AbsolutePathJs.MATCH_ALL,
): AsyncIterableJs<ValueInfoJs<*>> =
    @Suppress("UNCHECKED_CAST")
    valueInfo(formSchema.toSchemaKt() as Schema<Any?>, formValue, path.toPathKt())
        .toAsyncIterableJs { it.cachedToJs() }

@JsExport
@JsName("has")
public fun hasJs(formSchema: Any, formValue: Any?, path: Any): CancellablePromise<Boolean> =
    GlobalScope.cancellablePromise {
        @Suppress("UNCHECKED_CAST")
        has(formSchema.toSchemaKt() as Schema<Any?>, formValue, path.toPathKt())
    }

@JsExport
@JsName("get")
public fun getJs(formSchema: Any, formValue: Any?, path: Any): CancellablePromise<Any?> =
    GlobalScope.cancellablePromise {
        @Suppress("UNCHECKED_CAST")
        get(formSchema.toSchemaKt() as Schema<Any?>, formValue, path.toPathKt())
    }

@JsExport
@JsName("getClone")
public fun getCloneJs(formSchema: Any, formValue: Any?, path: Any): CancellablePromise<Any?> =
    GlobalScope.cancellablePromise {
        @Suppress("UNCHECKED_CAST")
        getClone(formSchema.toSchemaKt() as Schema<Any?>, formValue, path.toPathKt())
    }

@JsExport
@JsName("set")
public fun setJs(
    formSchema: Any,
    formValue: Any?,
    path: Any,
    toSet: Any?,
): CancellablePromise<Nothing?> =
    GlobalScope.cancellablePromise {
        @Suppress("UNCHECKED_CAST")
        set(formSchema.toSchemaKt() as Schema<Any?>, formValue, path.toPathKt(), toSet)
        undefined
    }

@JsExport
@JsName("reset")
public fun resetJs(formSchema: Any, formValue: Any?, path: Any): CancellablePromise<Nothing?> =
    GlobalScope.cancellablePromise {
        @Suppress("UNCHECKED_CAST")
        reset(formSchema.toSchemaKt() as Schema<Any?>, formValue, path.toPathKt())
        undefined
    }

@JsExport
@JsName("remove")
public fun removeJs(formSchema: Any, formValue: Any?, path: Any): CancellablePromise<Nothing?> =
    GlobalScope.cancellablePromise {
        @Suppress("UNCHECKED_CAST")
        remove(formSchema.toSchemaKt() as Schema<Any?>, formValue, path.toPathKt())
        undefined
    }

@JsExport
@JsName("validate")
public fun validateJs(
    formSchema: Any,
    formValue: Any?,
    pathOrExternalContexts: Any? = null,
    maybeExternalContexts: RecordTs<String, Any?>? = null,
): AsyncIterableJs<ValueInfoJs<*>> {
    val path: Path
    val externalContexts: RecordTs<String, Any?>?
    if (pathOrExternalContexts is PathJs || pathOrExternalContexts is String) {
        path = pathOrExternalContexts.toPathKt()
        externalContexts = maybeExternalContexts
    } else {
        path = AbsolutePath.MATCH_ALL
        @Suppress("UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
        externalContexts =
            if (pathOrExternalContexts == null) maybeExternalContexts
            else pathOrExternalContexts as RecordTs<String, Any?>?
    }
    @Suppress("UNCHECKED_CAST")
    return validate(
            formSchema.toSchemaKt() as Schema<Any?>,
            formValue,
            path,
            jsObjectToMap(externalContexts),
        )
        .toAsyncIterableJs { it.cachedToJs() }
}

@JsExport
@JsName("validateExternally")
public fun validateExternallyJs(
    formSchema: Any,
    formValue: Any?,
    pathOrExternalValidations: Any? = null,
    externalValidationsOrExternalContexts: RecordTs<String, Any?>? = null,
    maybeExternalContexts: RecordTs<String, Any?>? = null,
): AsyncIterableJs<ValueInfoJs<*>> {
    val path: Path
    val externalValidations: RecordTs<String, Array<Any>>?
    val externalContexts: RecordTs<String, Any?>?
    if (pathOrExternalValidations is PathJs || pathOrExternalValidations is String) {
        path = pathOrExternalValidations.toPathKt()
        @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
        externalValidations = externalValidationsOrExternalContexts as RecordTs<String, Array<Any>>?
        externalContexts = null
    } else {
        path = AbsolutePath.MATCH_ALL
        @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
        externalValidations = pathOrExternalValidations as RecordTs<String, Array<Any>>?
        externalContexts = maybeExternalContexts
    }
    @Suppress("UNCHECKED_CAST")
    return validateExternally(
            formSchema.toSchemaKt() as Schema<Any?>,
            formValue,
            path,
            jsObjectToMap(externalValidations) {
                it.map { validation -> validation.toValidationKt() }
            }
                as ExternalValidations,
            jsObjectToMap(externalContexts),
        )
        .toAsyncIterableJs { it.cachedToJs() }
}

@JsExport
@JsName("isValid")
public fun isValidJs(
    formSchema: Any,
    formValue: Any?,
    pathOrExternalContexts: Any? = null,
    maybeExternalContexts: RecordTs<String, Any?>? = null,
): CancellablePromise<Boolean> =
    GlobalScope.cancellablePromise {
        val path: Path
        val externalContexts: RecordTs<String, Any?>?
        if (pathOrExternalContexts is PathJs || pathOrExternalContexts is String) {
            path = pathOrExternalContexts.toPathKt()
            externalContexts = maybeExternalContexts
        } else {
            path = AbsolutePath.MATCH_ALL
            @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
            externalContexts =
                if (pathOrExternalContexts == null) maybeExternalContexts
                else pathOrExternalContexts as RecordTs<String, Any?>?
        }
        @Suppress("UNCHECKED_CAST")
        isValid(
            formSchema.toSchemaKt() as Schema<Any?>,
            formValue,
            path,
            jsObjectToMap(externalContexts),
        )
    }

@JsExport
@JsName("isValidExternally")
public fun isValidExternallyJs(
    formSchema: Any,
    formValue: Any?,
    pathOrExternalValidations: Any? = null,
    externalValidationsOrExternalContexts: RecordTs<String, Any?>? = null,
    maybeExternalContexts: RecordTs<String, Any?>? = null,
): CancellablePromise<Boolean> =
    GlobalScope.cancellablePromise {
        val path: Path
        val externalValidations: RecordTs<String, Array<Any>>?
        val externalContexts: RecordTs<String, Any?>?
        if (pathOrExternalValidations is PathJs || pathOrExternalValidations is String) {
            path = pathOrExternalValidations.toPathKt()
            @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
            externalValidations =
                externalValidationsOrExternalContexts as RecordTs<String, Array<Any>>?
            externalContexts = null
        } else {
            path = AbsolutePath.MATCH_ALL
            @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
            externalValidations = pathOrExternalValidations as RecordTs<String, Array<Any>>?
            externalContexts = maybeExternalContexts
        }
        @Suppress("UNCHECKED_CAST")
        isValidExternally(
            formSchema.toSchemaKt() as Schema<Any?>,
            formValue,
            path,
            jsObjectToMap(externalValidations) {
                it.map { validation -> validation.toValidationKt() }
            }
                as ExternalValidations,
            jsObjectToMap(externalContexts),
        )
    }
