import io.kform.validations.ExclusiveMax
import io.kform.validations.ExclusiveMin
import io.kform.validations.Max
import io.kform.validations.Min

/** [Minimum][Min] validation wrapper for use from JavaScript. */
@JsExport
@JsName("min")
public fun minJs(
    min: Double,
    code: String = Min.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> = Min(min, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Maximum][Max] validation wrapper for use from JavaScript. */
@JsExport
@JsName("max")
public fun maxJs(
    max: Double,
    code: String = Max.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> = Max(max, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Exclusive minimum][ExclusiveMin] validation wrapper for use from JavaScript. */
@JsExport
@JsName("exclusiveMin")
public fun exclusiveMinJs(
    exclusiveMin: Double,
    code: String = ExclusiveMin.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> =
    ExclusiveMin(exclusiveMin, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Exclusive maximum][ExclusiveMax] validation wrapper for use from JavaScript. */
@JsExport
@JsName("exclusiveMax")
public fun exclusiveMaxJs(
    exclusiveMax: Double,
    code: String = ExclusiveMax.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Double> =
    ExclusiveMax(exclusiveMax, code, severity.toValidationIssueSeverityKt()).cachedToJs()
