import io.kform.datatypes.File
import io.kform.validations.Accepts

/** [Accepts] validation wrapper for use from JavaScript. */
@Suppress("NON_EXPORTABLE_TYPE")
@JsExport
@JsName("accepts")
public fun acceptsJs(
    allowedFileTypes: Array<String>,
    code: String = Accepts.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<File> =
    Accepts(allowedFileTypes.toList(), code, severity.toValidationIssueSeverityKt()).cachedToJs()
