import io.kform.collections.PathMultimapEntry
import io.kform.collections.PathMultimapEntryId
import io.kform.collections.mutablePathMultimapOf

/**
 * [Path multimap entry][io.kform.collections.PathMultimapEntry] wrapper for use from JavaScript.
 */
@JsExport
@JsName("PathMultimapEntry")
public class PathMultimapEntryJs<T>
internal constructor(
    public val path: AbsolutePathJs,
    public val value: T,
    public val id: PathMultimapEntryId
)

/**
 * [Mutable path multimap][io.kform.collections.MutablePathMultimap] wrapper for use from
 * JavaScript.
 */
@JsExport
@JsName("PathMultimap")
public class PathMultimapJs<T>(pairs: Array<Array<Any>> = emptyArray()) {
    @Suppress("UNCHECKED_CAST")
    private val pathMultimapKt =
        mutablePathMultimapOf(*pairs.map { it[0].toPathKt() to it[1] as T }.toTypedArray())

    public val size: Int
        get() = pathMultimapKt.size

    public override fun toString(): String = pathMultimapKt.toString()

    public fun containsPath(path: Any): Boolean = pathMultimapKt.containsPath(path.toPathKt())

    public fun containsEntry(entryId: PathMultimapEntryId): Boolean =
        pathMultimapKt.containsEntry(entryId)

    public fun containsValue(value: T): Boolean = pathMultimapKt.containsValue(value)

    public fun get(path: Any): IterableJs<T> = pathMultimapKt[path.toPathKt()].toIterableJs { it }

    public fun getEntry(entryId: PathMultimapEntryId): PathMultimapEntryJs<T>? =
        pathMultimapKt[entryId]?.toJs()

    public fun put(path: Any, value: T): PathMultimapEntryId =
        pathMultimapKt.put(path.toPathKt(), value)

    public fun remove(path: Any): Array<PathMultimapEntryJs<T>> =
        pathMultimapKt.remove(path.toPathKt()).map { it.toJs() }.toTypedArray()

    public fun removeEntry(entryId: PathMultimapEntryId): PathMultimapEntryJs<T>? =
        pathMultimapKt.removeEntry(entryId)?.toJs()

    public fun clear(): Unit = pathMultimapKt.clear()

    public fun entries(path: Any = AbsolutePathJs.MATCH_ALL): IterableJs<PathMultimapEntryJs<T>> =
        pathMultimapKt.entries(path.toPathKt()).toIterableJs { it.toJs() }
}

/**
 * Function which converts a [PathMultimapEntry] into a wrapped [PathMultimapEntryJs] object to be
 * used from JavaScript.
 */
private fun <T> PathMultimapEntry<T>.toJs() =
    PathMultimapEntryJs(this.path.cachedToJs(), this.value, this.id)
