import io.kform.validations.Matches
import io.kform.validations.MatchesEmail
import kotlin.js.RegExp

/** Converts a JS regular expression into a Kotlin one. */
private fun jsRegexToKotlinRegex(regex: RegExp): Regex =
    Regex(
        regex.asDynamic().source as String,
        buildSet {
            if (regex.ignoreCase) {
                add(RegexOption.IGNORE_CASE)
            }
            if (regex.multiline) {
                add(RegexOption.MULTILINE)
            }
        }
    )

/** Matches validation for use from JavaScript. */
@JsExport
@JsName("matches")
public fun matchesJs(
    regex: RegExp,
    code: String = Matches.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<String> =
    Matches(jsRegexToKotlinRegex(regex), code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** Matches email validation for use from JavaScript. */
@JsExport
@JsName("matchesEmail")
public fun matchesEmailJs(
    code: String = MatchesEmail.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
    regex: RegExp? = null,
): ValidationJs<String> =
    MatchesEmail(
            code,
            severity.toValidationIssueSeverityKt(),
            if (regex == null) MatchesEmail.EMAIL_REGEX else jsRegexToKotlinRegex(regex)
        )
        .cachedToJs()
