import io.kform.validations.MustEqual
import io.kform.validations.MustNotEqual
import io.kform.validations.NotOneOf
import io.kform.validations.OneOf

/** [Must equal][MustEqual] validation wrapper for use from JavaScript. */
@JsExport
@JsName("mustEqual")
public fun <T> mustEqualJs(
    requiredValue: T,
    code: String = MustEqual.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error"
): ValidationJs<T> =
    MustEqual(requiredValue, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Must not equal][MustNotEqual] validation wrapper for use from JavaScript. */
@JsExport
@JsName("mustNotEqual")
public fun <T> mustNotEqualJs(
    forbiddenValue: T,
    code: String = MustNotEqual.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error"
): ValidationJs<T> =
    MustNotEqual(forbiddenValue, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [One of][OneOf] validation wrapper for use from JavaScript. */
@JsExport
@JsName("oneOf")
public fun <T> oneOfJs(
    allowedValues: Array<T>,
    code: String = OneOf.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<T> =
    OneOf(allowedValues.toSet(), code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Not one of][NotOneOf] validation wrapper for use from JavaScript. */
@JsExport
@JsName("notOneOf")
public fun <T> notOneOfJs(
    disallowedValues: Array<T>,
    code: String = NotOneOf.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<T> =
    NotOneOf(disallowedValues.toSet(), code, severity.toValidationIssueSeverityKt()).cachedToJs()
