import io.kform.datatypes.Table
import io.kform.datatypes.TableRowId
import io.kform.datatypes.toTable

// Utilities for working with listables from JavaScript:

@JsExport
public fun listableSize(value: Any?): Int =
    when (value) {
        is Array<*> -> value.size
        is Table<*> -> value.size
        is Collection<*> -> value.size
        else ->
            throw IllegalArgumentException(
                "Unsupported value type: only Collections, Tables, and Arrays are supported."
            )
    }

@JsExport
public fun listableToArray(value: Any?): Array<*> =
    when (value) {
        is Array<*> -> value
        is Table<*> -> value.values.toTypedArray()
        is Collection<*> -> value.toTypedArray()
        else ->
            throw IllegalArgumentException(
                "Unsupported value type: only Collections, Tables, and Arrays are supported."
            )
    }

@JsExport public fun isList(value: Any?): Boolean = value is List<*>

@JsExport public fun isTable(value: Any?): Boolean = value is Table<*>

@JsExport
public fun sliceList(value: Any, fromIndex: Int? = null, toIndex: Int? = null): Array<*> =
    when (value) {
        is List<*> -> value.subList(fromIndex ?: 0, toIndex ?: value.size).toTypedArray()
        else ->
            throw IllegalArgumentException("Unsupported value type: argument must be of type List.")
    }

@JsExport
public fun sliceTable(value: Any, fromIndex: Int? = null, toIndex: Int? = null): Array<*> =
    when (value) {
        is Table<*> ->
            value
                .subList(fromIndex ?: 0, toIndex ?: value.size)
                .map { arrayOf(it.id, it.value) }
                .toTypedArray()
        else ->
            throw IllegalArgumentException(
                "Unsupported value type: argument must be of type Table."
            )
    }

@JsExport public fun arrayToList(value: Array<*>): Any = value.toList()

@JsExport public fun arrayToTable(value: Array<*>): Any = value.toTable()

@JsExport
public fun indexOfTableRowId(table: Any, id: TableRowId): Int =
    if (table is Table<*>) table.indexOfId(id)
    else throw IllegalArgumentException("Unsupported value type: argument must be of type Table.")
