import io.kform.datatypes.Table
import io.kform.datatypes.tableOf
import io.kform.schemas.TableSchema

/** Schema representing a table. */
@Suppress("NON_EXPORTABLE_TYPE")
@JsName("tableSchema")
@JsExport
public fun <T> tableSchemaJs(
    optionsOrElementsSchema: Any,
    elementsSchema: SchemaJs<T>? = null
): SchemaJs<Table<T>> =
    @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
    when (elementsSchema) {
        null -> TableSchema((optionsOrElementsSchema as SchemaJs<T>).schemaKt)
        else -> {
            val options = optionsOrElementsSchema as SchemaOptionsJs<Table<T>>
            TableSchema(
                elementsSchema.schemaKt,
                options.validations?.map { it.validationKt } ?: emptyList(),
                options.initialValue ?: tableOf()
            )
        }
    }.cachedToJs()
