import io.kform.validations.Unique
import io.kform.validations.UniqueBy

/** [Unique by][UniqueBy] validation for use from JavaScript. */
@JsExport
@JsName("uniqueBy")
public fun <T, TKey> uniqueByJs(
    selector: (element: T) -> TKey?,
    emitAllRepetitions: Boolean = true,
    code: String = UniqueBy.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error"
): ValidationJs<Array<T>> =
    UniqueBy(emitAllRepetitions, code, severity.toValidationIssueSeverityKt(), selector)
        .cachedToJs()

/** [Unique] validation for use from JavaScript. */
@JsExport
@JsName("unique")
public fun <T> uniqueJs(
    emitAllRepetitions: Boolean = true,
    treatNullAsUnique: Boolean = true,
    code: String = Unique.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Array<T>> =
    Unique(emitAllRepetitions, treatNullAsUnique, code, severity.toValidationIssueSeverityKt())
        .cachedToJs()
