import kotlinx.datetime.Instant
import kotlinx.datetime.LocalDate
import kotlinx.datetime.LocalDateTime

// Utilities for working with temporal values ([Instant], [LocalDate], [LocalDateTime]) from
// JavaScript:

@JsExport public fun isInstant(value: Any?): Boolean = value is Instant

@JsExport public fun isLocalDate(value: Any?): Boolean = value is LocalDate

@JsExport public fun isLocalDateTime(value: Any?): Boolean = value is LocalDateTime

@JsExport public fun stringToInstant(isoString: String): Any = Instant.parse(isoString)

@JsExport public fun stringToLocalDate(isoString: String): Any = LocalDate.parse(isoString)

@JsExport public fun stringToLocalDateTime(isoString: String): Any = LocalDateTime.parse(isoString)
