import io.kform.TypeInfo
import io.kform.Validation
import io.kform.schemas.AbstractSimpleSchema
import kotlin.js.Date
import kotlin.reflect.KClass
import kotlin.reflect.KType

/** Schema representing JS dates. */
internal class DateSchemaJs(
    validations: Iterable<Validation<Date>> = emptyList(),
    override val initialValue: Date = DEFAULT_INITIAL_VALUE
) : AbstractSimpleSchema<Date>(validations) {
    override val typeInfo: TypeInfo = TypeInfo("Date")

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(DEFAULT_INITIAL_VALUE) == true

    override suspend fun fromAny(value: Any?): Date =
        when (value) {
            is Date -> value
            is Number -> Date(value.toDouble())
            is String -> Date(value)
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Date.")
        }

    companion object {
        /** Default initial value (epoch). */
        val DEFAULT_INITIAL_VALUE: Date = Date(0)
    }
}

/** JS date schema for use from JavaScript. */
@JsName("dateSchema")
@JsExport
public fun dateSchemaJs(options: SchemaOptionsJs<Date>? = null): SchemaJs<Date> =
    DateSchemaJs(
            options?.validations?.map { it.validationKt } ?: emptyList(),
            options?.initialValue ?: DateSchemaJs.DEFAULT_INITIAL_VALUE
        )
        .cachedToJs()
