/**
 * Provies a way of accessing the `arguments` passed to a function in JavaScript.
 *
 * This is useful in order to define functions to be exposed to JavaScript that take a variable
 * number of arguments (Kotlin's `vararg` expects an array to be passed as argument).
 */
@Suppress("NOTHING_TO_INLINE", "UnsafeCastFromDynamic")
internal inline fun <T> functionArguments(): Array<T> = js("Array.from(arguments)")
