@file:OptIn(ExperimentalJsExport::class)

import io.kform.schemas.DoubleSchema

/**
 * Schema representing JavaScript numbers. Wraps a [double schema][DoubleSchema] for use from
 * JavaScript.
 */
@JsName("numberSchema")
@JsExport
public fun numberSchemaJs(options: SchemaOptionsJs<Double>? = null): SchemaJs<Double> =
    DoubleSchema(
            options?.validations?.map { it.validationKt } ?: emptyList(),
            options?.initialValue ?: 0.0
        )
        .cachedToJs()
