@file:OptIn(ExperimentalJsExport::class)

import io.kform.TypeInfo
import io.kform.Validation
import io.kform.schemas.AbstractSimpleSchema
import kotlin.js.Date

/** Schema representing JS dates. */
internal class DateSchemaJs(
    validations: Iterable<Validation<Date>> = emptyList(),
    override val initialValue: Date = DEFAULT_INITIAL_VALUE
) : AbstractSimpleSchema<Date>(validations) {
    override val typeInfo: TypeInfo = TypeInfo("Date")

    companion object {
        /** Default initial value (epoch). */
        val DEFAULT_INITIAL_VALUE: Date = Date(0)
    }
}

/** JS date schema for use from JavaScript. */
@JsName("dateSchema")
@JsExport
public fun dateSchemaJs(options: SchemaOptionsJs<Date>? = null): SchemaJs<Date> =
    DateSchemaJs(
            options?.validations?.map { it.validationKt } ?: emptyList(),
            options?.initialValue ?: DateSchemaJs.DEFAULT_INITIAL_VALUE
        )
        .cachedToJs()
