@file:OptIn(ExperimentalJsExport::class)

import io.kform.File
import io.kform.validations.AllowedFileExtensions
import io.kform.validations.AllowedMimeTypes
import io.kform.validations.NotOneOf

/** [Allowed MIME types][AllowedMimeTypes] validation wrapper for use from JavaScript. */
@JsExport
@JsName("allowedMimeTypes")
public fun allowedMimeTypesJs(
    allowedMimeTypes: Array<String>,
    code: String = AllowedMimeTypes.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<File> =
    AllowedMimeTypes(allowedMimeTypes.toList(), code, severity.toValidationIssueSeverityKt())
        .cachedToJs()

/** [Allowed file extensions][AllowedFileExtensions] validation wrapper for use from JavaScript. */
@JsExport
@JsName("allowedFileExtensions")
public fun allowedFileExtensionsJs(
    allowedFileExtensions: Array<String>,
    code: String = NotOneOf.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<File> =
    AllowedFileExtensions(
            allowedFileExtensions.toList(),
            code,
            severity.toValidationIssueSeverityKt()
        )
        .cachedToJs()
