@file:OptIn(ExperimentalJsExport::class)

import io.kform.File
import io.kform.emplyPlaceholderFile
import kotlin.js.Promise
import org.khronos.webgl.ArrayBuffer
import org.khronos.webgl.Int8Array
import org.w3c.files.File as FileJs
import org.w3c.files.FilePropertyBag
import org.w3c.files.FileReader

// Utilities for working with [File]s from JavaScript:

@JsExport
public fun kFormFileToJsFile(file: Any): FileJs =
    getOrSetFromCache(file as File) {
        FileJs(arrayOf(file.data), file.name, FilePropertyBag(type = file.type))
    }

@JsExport
public fun jsFileToKFormFile(file: FileJs): Promise<Any> =
    getOrSetFromCache(file) {
        val fr = FileReader()
        fr.readAsArrayBuffer(file)
        Promise { res, rej ->
            fr.onload = {
                res(
                    File(
                        file.name,
                        Int8Array(fr.result as ArrayBuffer).asDynamic() as ByteArray,
                        file.type.ifEmpty { null }
                    )
                )
            }
            fr.onerror = { rej(Error("Failed to read the file.")) }
        }
    }

@JsExport public fun emptyPlaceholderKFormFile(): Any = emplyPlaceholderFile()
