@file:OptIn(ExperimentalJsExport::class)

import io.kform.Schema
import io.kform.schemas.NullableSchema

/** [Nullable schema][NullableSchema] wrapper for use from JavaScript. */
@JsName("nullableSchema")
@JsExport
public fun <T> nullableSchemaJs(
    optionsOrChildSchema: Any,
    childSchema: SchemaJs<T>? = null
): SchemaJs<T?> =
    @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
    when (optionsOrChildSchema) {
        is SchemaJs<*> -> NullableSchema { optionsOrChildSchema.schemaKt as Schema<T> }
        else -> {
            val options = optionsOrChildSchema as SchemaOptionsJs<T?>
            NullableSchema(
                options.initialValue,
                options.validations?.map { it.validationKt } ?: emptyList()
            ) {
                childSchema!!.schemaKt
            }
        }
    }.cachedToJs()
