/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.service.mock;

import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import io.keploy.regression.keploy.AppConfig;
import io.keploy.regression.keploy.Keploy;
import io.keploy.regression.keploy.ServerConfig;
import io.keploy.service.GrpcService;
import io.keploy.service.mock.Config;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MockLib {
    private static final Logger logger = LogManager.getLogger(MockLib.class);
    static Keploy k = null;
    AppConfig appConfig = new AppConfig();

    public MockLib(String name) {
        KeployInstance ki = KeployInstance.getInstance();
        k = ki.getKeploy();
        io.keploy.regression.keploy.Config cfg = new io.keploy.regression.keploy.Config();
        Config.Name = name;
        this.appConfig.setName(Config.Name);
        cfg.setApp(this.appConfig);
        ServerConfig serverConfig = new ServerConfig();
        if (System.getenv("DENOISE") != null) {
            serverConfig.setDenoise(Boolean.valueOf(Boolean.parseBoolean(System.getenv("DENOISE"))));
        }
        if (System.getenv("KEPLOY_URL") != null) {
            serverConfig.setURL(System.getenv("KEPLOY_URL"));
        }
        cfg.setApp(this.appConfig);
        cfg.setServer(serverConfig);
        k.setCfg(cfg);
        new GrpcService();
        Kcontext ctx = this.NewContext();
        System.out.println(ctx);
    }

    public Kcontext NewContext() {
        Config.mode = Mode.ModeType.MODE_TEST;
        String mpath = System.getenv("KEPLOY_MOCK_PATH");
        Path path = Paths.get("", new String[0]);
        if (mpath != null && mpath.length() > 0 && !Paths.get(mpath, new String[0]).isAbsolute()) {
            Path effectivePath = path.resolve(mpath).toAbsolutePath();
            String absolutePath = effectivePath.normalize().toString();
            this.appConfig.setMockPath(absolutePath);
        } else if (mpath == null || mpath.length() == 0) {
            String currDir;
            mpath = currDir = System.getProperty("user.dir") + "/src/test/e2e/mocks";
            this.appConfig.setMockPath(currDir);
        } else {
            this.appConfig.setMockPath(mpath);
        }
        Config.MockPath = this.appConfig.getMockPath();
        logger.debug("mock path: {}", (Object)this.appConfig.getMockPath());
        Config.mode = System.getenv().getOrDefault("KEPLOY_MODE", "test").equals("record") ? Mode.ModeType.MODE_RECORD : Mode.ModeType.MODE_TEST;
        ArrayList<Object> mocks = new ArrayList();
        if (Config.mode == Mode.ModeType.MODE_TEST) {
            Service.GetMockReq request;
            if (k.getCfg().getApp().getName() == null || k.getCfg().getApp().getName().length() == 0) {
                logger.error("Please enter the auto generated name to mock the dependencies using Keploy !");
            }
            if ((mocks = MockLib.GetAllMocks(request = Service.GetMockReq.newBuilder().setName(k.getCfg().getApp().getName()).setPath(mpath).build())) == null) {
                logger.error("No mocks found for the given name: {}", (Object)k.getCfg().getApp().getName());
                logger.error("Failed to get the mocks from keploy server. Please ensure that keploy server is running.");
            }
        }
        Kcontext kctx = new Kcontext();
        Context.setCtx((Kcontext)kctx);
        kctx.setMock(mocks);
        kctx.setMode(Config.mode);
        kctx.setTestId(this.appConfig.getName());
        kctx.setFileExport(Boolean.valueOf(true));
        String name = "";
        if (k.getCfg().getApp().getName() != null) {
            name = " for " + k.getCfg().getApp().getName();
        }
        System.out.println(name + " -=-==-=-=-= " + Config.mode.value);
        logger.info("Keploy created new mocking context in {} mode {}.If you dont see any logs about your dependencies below, your dependency/s are NOT wrapped.", (Object)Config.mode, (Object)name);
        boolean exists = MockLib.StartRecordingMocks(kctx, mpath, Config.mode.value, name, Config.Overwrite);
        if (exists && !Config.Overwrite.booleanValue()) {
            logger.error(" Keploy failed to record dependencies because yaml file already exists {} in directory: {}.", (Object)name, (Object)mpath);
            Config.MockId.put(name, true);
        }
        return kctx;
    }

    public static boolean StartRecordingMocks(Kcontext kctx, String path, String mode, String name, Boolean overWrite) {
        Service.StartMockReq startMockReq = Service.StartMockReq.newBuilder().setMode(mode).setPath(path).setName(name).setOverWrite(overWrite.booleanValue()).build();
        Service.StartMockResp startMockResp = GrpcService.blockingStub.startMocking(startMockReq);
        if (startMockResp == null) {
            logger.error("Failed to make StartMocking grpc call to keploy server" + name + " mock");
            return false;
        }
        return startMockResp.getExists();
    }

    public static ArrayList<Service.Mock> GetAllMocks(Service.GetMockReq getMockReq) {
        Service.getMockResp resp = GrpcService.blockingStub.getMocks(getMockReq);
        if (resp != null) {
            if (resp.getMocksList().size() == 0) {
                logger.info("Mocklist size is zero !!");
                return null;
            }
            return MockLib.getM(resp.getMocksList());
        }
        logger.error("returned nil as array mocks from keploy server");
        return null;
    }

    private static ArrayList<Service.Mock> getM(List<Service.Mock> mocksList) {
        ArrayList<Service.Mock> mockArrayList = new ArrayList<Service.Mock>();
        for (int i = 0; i < mocksList.size(); ++i) {
            mockArrayList.add(mocksList.get(0));
        }
        return mockArrayList;
    }

    public static boolean PutMock(String path, Service.Mock mock) {
        Service.PutMockReq putMockReq = Service.PutMockReq.newBuilder().setMock(mock).setPath(path).build();
        Service.PutMockResp putMockResp = GrpcService.blockingStub.putMock(putMockReq);
        if (putMockResp == null) {
            logger.error("Failed to call the putMock method");
            return false;
        }
        return true;
    }
}

