/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlAlter;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlAlterTableExtension
extends SqlAlter {
    public static final SqlOperator OPERATOR = new SqlSpecialOperator("ALTER TABLE", SqlKind.OTHER_DDL);
    public final boolean ifExists;
    public final SqlIdentifier name;
    public final List<Action> actions;
    public final SqlNodeList columnList;

    public SqlAlterTableExtension(SqlParserPos pos, boolean ifExists, SqlIdentifier name, List<Action> actions, SqlNodeList columnList) {
        super(pos, "TABLE");
        this.ifExists = ifExists;
        this.name = Objects.requireNonNull(name);
        this.actions = actions;
        this.columnList = columnList;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name, (Object)this.columnList);
    }

    protected void unparseAlterOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.ifExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("", "");
            for (int i = 0; i < this.columnList.size(); ++i) {
                Action a = this.actions.get(i);
                SqlNode c = this.columnList.get(i);
                writer.sep(",");
                writer.keyword(a.name());
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    public static enum Action {
        ADD,
        ALTER,
        DROP;

    }
}

