/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.kareldb.schema.ColumnStrategy;
import io.kareldb.schema.RelDef;
import io.kareldb.schema.Schema;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.ContextSqlValidator;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.server.DdlExecutor;
import org.apache.calcite.server.DdlExecutorImpl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlAlterTableExtension;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlCreateTableExtension;
import org.apache.calcite.sql.ddl.SqlDropTableExtension;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.parserextension.ExtensionSqlParserImpl;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class ExtensionDdlExecutor
extends DdlExecutorImpl {
    static final ExtensionDdlExecutor INSTANCE = new ExtensionDdlExecutor();
    public static final SqlParserImplFactory PARSER_FACTORY = new SqlParserImplFactory(){

        public SqlAbstractParserImpl getParser(Reader stream) {
            return ExtensionSqlParserImpl.FACTORY.getParser(stream);
        }

        public DdlExecutor getDdlExecutor() {
            return INSTANCE;
        }
    };

    public void execute(SqlCreateTableExtension create, CalcitePrepare.Context context) {
        String tableName;
        ArrayList<SqlIdentifier> columnList;
        RelDataType queryRowType;
        CalciteSchema schema = Schemas.subSchema((CalciteSchema)context.getRootSchema(), (Iterable)context.getDefaultSchemaPath());
        JavaTypeFactory typeFactory = context.getTypeFactory();
        if (create.query != null) {
            String sql = create.query.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
            ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)schema.plus(), (String)sql, (List)schema.path(null), (List)context.getObjectPath(), (Boolean)false);
            TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
            queryRowType = x.getRowType((RelDataTypeFactory)typeFactory);
            if (create.columnList != null && queryRowType.getFieldCount() != create.columnList.size()) {
                throw SqlUtil.newContextException((SqlParserPos)create.columnList.getParserPosition(), (Resources.ExInst)Static.RESOURCE.columnCountMismatch());
            }
        } else {
            queryRowType = null;
        }
        if (create.columnList != null) {
            columnList = create.columnList.getList();
        } else {
            if (queryRowType == null) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.createTableRequiresColumnList());
            }
            columnList = new ArrayList<SqlIdentifier>();
            for (String name : queryRowType.getFieldNames()) {
                columnList.add(new SqlIdentifier(name, SqlParserPos.ZERO));
            }
        }
        ImmutableList.Builder b = ImmutableList.builder();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        RelDataTypeFactory.FieldInfoBuilder storedBuilder = typeFactory.builder();
        ContextSqlValidator validator = new ContextSqlValidator(context, false);
        ArrayList<String> keyFields = new ArrayList<String>();
        ArrayList<io.kareldb.schema.ColumnStrategy> strategies = new ArrayList<io.kareldb.schema.ColumnStrategy>();
        for (Ord c : Ord.zip(columnList)) {
            if (c.e instanceof SqlColumnDeclaration) {
                SqlColumnDeclaration d = (SqlColumnDeclaration)c.e;
                RelDataType type = d.dataType.deriveType((SqlValidator)validator, true);
                builder.add(d.name.getSimple(), type);
                if (d.strategy != ColumnStrategy.VIRTUAL) {
                    storedBuilder.add(d.name.getSimple(), type);
                }
                b.add((Object)ColumnDef.of(d.expression, type, d.strategy));
                this.addStrategy(strategies, d.strategy, d.expression);
                continue;
            }
            if (c.e instanceof SqlIdentifier) {
                SqlIdentifier id = (SqlIdentifier)c.e;
                if (queryRowType == null) {
                    throw SqlUtil.newContextException((SqlParserPos)id.getParserPosition(), (Resources.ExInst)Static.RESOURCE.createTableRequiresColumnTypes(id.getSimple()));
                }
                RelDataTypeField f = (RelDataTypeField)queryRowType.getFieldList().get(c.i);
                ColumnStrategy strategy = f.getType().isNullable() ? ColumnStrategy.NULLABLE : ColumnStrategy.NOT_NULLABLE;
                b.add((Object)ColumnDef.of((SqlNode)c.e, f.getType(), strategy));
                builder.add(id.getSimple(), f.getType());
                storedBuilder.add(id.getSimple(), f.getType());
                this.addStrategy(strategies, strategy, null);
                continue;
            }
            if (c.e instanceof SqlKeyConstraint) {
                SqlKeyConstraint keyConstraint = (SqlKeyConstraint)c.e;
                if (keyConstraint.getOperator() != SqlKeyConstraint.PRIMARY) continue;
                List operands = keyConstraint.getOperandList();
                SqlNodeList sqlNodeList = (SqlNodeList)operands.get(1);
                List keyNodes = sqlNodeList.getList();
                for (SqlNode keyNode : keyNodes) {
                    keyFields.add(((SqlIdentifier)keyNode).getSimple());
                }
                continue;
            }
            throw new AssertionError(((SqlNode)c.e).getClass());
        }
        RelDataType rowType = builder.build();
        RelDataType storedRowType = storedBuilder.build();
        ImmutableList columns = b.build();
        NullInitializerExpressionFactory ief = new NullInitializerExpressionFactory((List)columns){
            final /* synthetic */ List val$columns;
            {
                this.val$columns = list;
            }

            public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
                return ((ColumnDef)this.val$columns.get((int)iColumn)).strategy;
            }

            public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
                ColumnDef c = (ColumnDef)this.val$columns.get(iColumn);
                if (c.expr != null) {
                    return context.convertExpression(c.expr);
                }
                return super.newColumnDefaultValue(table, iColumn, context);
            }
        };
        Schema schemaPlus = (Schema)schema.plus().unwrap(Schema.class);
        if (schemaPlus.getTable(tableName = create.name.getSimple()) != null) {
            if (!create.ifNotExists) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableExists(tableName));
            }
            return;
        }
        if (keyFields.isEmpty()) {
            keyFields.add(((RelDataTypeField)rowType.getFieldList().get(0)).getName());
        }
        io.kareldb.schema.Table table = schemaPlus.createTable(tableName, null, new RelDef(rowType, keyFields, strategies));
        schema.add(tableName, (Table)table);
        if (create.query != null) {
            ExtensionDdlExecutor.populate(create.name, create.query, context);
        }
    }

    public void execute(SqlAlterTableExtension alter, CalcitePrepare.Context context) {
        String tableName;
        CalciteSchema schema = Schemas.subSchema((CalciteSchema)context.getRootSchema(), (Iterable)context.getDefaultSchemaPath());
        JavaTypeFactory typeFactory = context.getTypeFactory();
        List columnList = alter.columnList.getList();
        ImmutableList.Builder b = ImmutableList.builder();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        RelDataTypeFactory.FieldInfoBuilder storedBuilder = typeFactory.builder();
        ContextSqlValidator validator = new ContextSqlValidator(context, false);
        ArrayList<String> keyFields = new ArrayList<String>();
        ArrayList<io.kareldb.schema.ColumnStrategy> strategies = new ArrayList<io.kareldb.schema.ColumnStrategy>();
        for (Ord c : Ord.zip((List)columnList)) {
            if (c.e instanceof SqlColumnDeclaration) {
                SqlColumnDeclaration d = (SqlColumnDeclaration)c.e;
                RelDataType type = d.dataType.deriveType((SqlValidator)validator, true);
                builder.add(d.name.getSimple(), type);
                if (d.strategy != ColumnStrategy.VIRTUAL) {
                    storedBuilder.add(d.name.getSimple(), type);
                }
                b.add((Object)ColumnDef.of(d.expression, type, d.strategy));
                this.addStrategy(strategies, d.strategy, d.expression);
                continue;
            }
            if (c.e instanceof SqlIdentifier) {
                SqlIdentifier id = (SqlIdentifier)c.e;
                RelDataType nullType = typeFactory.createSqlType(SqlTypeName.NULL);
                builder.add(id.getSimple(), nullType);
                this.addStrategy(strategies, ColumnStrategy.NULLABLE, null);
                continue;
            }
            throw new AssertionError(((SqlNode)c.e).getClass());
        }
        RelDataType rowType = builder.build();
        RelDataType storedRowType = storedBuilder.build();
        ImmutableList columns = b.build();
        NullInitializerExpressionFactory ief = new NullInitializerExpressionFactory((List)columns){
            final /* synthetic */ List val$columns;
            {
                this.val$columns = list;
            }

            public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
                return ((ColumnDef)this.val$columns.get((int)iColumn)).strategy;
            }

            public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
                ColumnDef c = (ColumnDef)this.val$columns.get(iColumn);
                if (c.expr != null) {
                    return context.convertExpression(c.expr);
                }
                return super.newColumnDefaultValue(table, iColumn, context);
            }
        };
        Schema schemaPlus = (Schema)schema.plus().unwrap(Schema.class);
        if (schemaPlus.getTable(tableName = alter.name.getSimple()) == null) {
            if (!alter.ifExists) {
                throw SqlUtil.newContextException((SqlParserPos)alter.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableNameNotFound(tableName));
            }
            return;
        }
        schemaPlus.alterTable(tableName, alter.actions, new RelDef(rowType, keyFields, strategies));
    }

    public void execute(SqlDropTableExtension drop, CalcitePrepare.Context context) {
        CalciteSchema schema = Schemas.subSchema((CalciteSchema)context.getRootSchema(), (Iterable)context.getDefaultSchemaPath());
        String tableName = drop.name.getSimple();
        switch (drop.getKind()) {
            case DROP_TABLE: {
                Schema schemaPlus = (Schema)schema.plus().unwrap(Schema.class);
                boolean existed = schemaPlus.dropTable(tableName);
                schema.removeTable(tableName);
                if (existed || drop.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)drop.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableNotFound(tableName));
            }
            default: {
                throw new AssertionError(drop.getKind());
            }
        }
    }

    private void addStrategy(List<io.kareldb.schema.ColumnStrategy> strategies, ColumnStrategy strategy, SqlNode expression) {
        switch (strategy) {
            case NULLABLE: {
                strategies.add(io.kareldb.schema.ColumnStrategy.NULL_STRATEGY);
                break;
            }
            case NOT_NULLABLE: {
                strategies.add(io.kareldb.schema.ColumnStrategy.NOT_NULL_STRATEGY);
                break;
            }
            case DEFAULT: {
                if (expression instanceof SqlLiteral) {
                    strategies.add(new ColumnStrategy.DefaultStrategy(((SqlLiteral)expression).getValue()));
                    break;
                }
                strategies.add(io.kareldb.schema.ColumnStrategy.NOT_NULL_STRATEGY);
                break;
            }
            default: {
                strategies.add(io.kareldb.schema.ColumnStrategy.NOT_NULL_STRATEGY);
            }
        }
    }

    protected static void populate(SqlIdentifier name, SqlNode query, CalcitePrepare.Context context) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(Objects.requireNonNull(Schemas.subSchema((CalciteSchema)context.getRootSchema(), (Iterable)context.getDefaultSchemaPath())).plus()).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        try {
            StringBuilder buf = new StringBuilder();
            SqlPrettyWriter w = new SqlPrettyWriter(SqlPrettyWriter.config().withDialect(CalciteSqlDialect.DEFAULT).withAlwaysUseParentheses(false), buf);
            buf.append("INSERT INTO ");
            name.unparse((SqlWriter)w, 0, 0);
            buf.append(" ");
            query.unparse((SqlWriter)w, 0, 0);
            String sql = buf.toString();
            SqlNode query1 = planner.parse(sql);
            SqlNode query2 = planner.validate(query1);
            RelRoot r = planner.rel(query2);
            PreparedStatement prepare = context.getRelRunner().prepare(r.rel);
            int rowCount = prepare.executeUpdate();
            Util.discard((int)rowCount);
            prepare.close();
        }
        catch (SQLException | SqlParseException | RelConversionException | ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ColumnDef {
        final SqlNode expr;
        final RelDataType type;
        final ColumnStrategy strategy;

        private ColumnDef(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            this.expr = expr;
            this.type = type;
            this.strategy = Objects.requireNonNull(strategy);
            Preconditions.checkArgument((strategy == ColumnStrategy.NULLABLE || strategy == ColumnStrategy.NOT_NULLABLE || expr != null ? 1 : 0) != 0);
        }

        static ColumnDef of(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            return new ColumnDef(expr, type, strategy);
        }
    }
}

