/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.version;

import io.kareldb.KarelDbEngine;
import io.kareldb.schema.Table;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.VersionedValue;
import io.kcache.Cache;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import io.kcache.utils.InMemoryCache;
import io.kcache.utils.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;
import org.apache.omid.transaction.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedCache
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(VersionedCache.class);
    private final String name;
    private final Cache<Comparable[], NavigableMap<Long, VersionedValue>> cache;

    public VersionedCache(String name) {
        this(name, (Cache<Comparable[], NavigableMap<Long, VersionedValue>>)new InMemoryCache((Comparator)new Table.ComparableArrayComparator()));
    }

    public VersionedCache(String name, Cache<Comparable[], NavigableMap<Long, VersionedValue>> cache) {
        this.name = name;
        this.cache = cache;
    }

    public String getName() {
        return this.name;
    }

    public VersionedValue get(Comparable[] key, long version) {
        NavigableMap rowData = (NavigableMap)this.cache.get((Object)key);
        return rowData != null ? (VersionedValue)rowData.get(version) : null;
    }

    public List<VersionedValue> get(Comparable[] key, long minVersion, long maxVersion) {
        NavigableMap rowData = (NavigableMap)this.cache.get((Object)key);
        return rowData != null ? VersionedCache.getAll(rowData, minVersion, maxVersion) : Collections.emptyList();
    }

    private static List<VersionedValue> getAll(NavigableMap<Long, VersionedValue> rowdata, long minVersion, long maxVersion) {
        ArrayList<VersionedValue> all = new ArrayList<VersionedValue>(rowdata.subMap(minVersion, true, maxVersion, true).descendingMap().values());
        return all;
    }

    public void put(Comparable[] key, long version, Comparable[] value) {
        NavigableMap rowData = (NavigableMap)this.cache.getOrDefault((Object)key, new ConcurrentSkipListMap());
        rowData.put(version, new VersionedValue(version, 0L, false, value));
        this.garbageCollect(rowData);
        this.cache.put((Object)key, (Object)rowData);
    }

    public boolean setCommit(Comparable[] key, long version, long commit) {
        NavigableMap rowData = (NavigableMap)this.cache.getOrDefault((Object)key, new ConcurrentSkipListMap());
        VersionedValue value = (VersionedValue)rowData.get(version);
        if (value == null) {
            return false;
        }
        if (commit == -1L) {
            rowData.remove(version);
        } else {
            rowData.put(version, new VersionedValue(version, commit, value.isDeleted(), value.getValue()));
        }
        this.garbageCollect(rowData);
        this.cache.put((Object)key, (Object)rowData);
        return true;
    }

    public void remove(Comparable[] key, long version) {
        NavigableMap rowData = (NavigableMap)this.cache.getOrDefault((Object)key, new ConcurrentSkipListMap());
        rowData.put(version, new VersionedValue(version, 0L, true, Table.EMPTY_VALUE));
        this.garbageCollect(rowData);
        this.cache.put((Object)key, (Object)rowData);
    }

    private void garbageCollect(NavigableMap<Long, VersionedValue> rowData) {
        try {
            long lowWaterMark;
            ArrayList<Long> oldVersions;
            KarelDbTransactionManager txManager = KarelDbEngine.getInstance().getTxManager();
            if (txManager != null && (oldVersions = new ArrayList<Long>(rowData.headMap(lowWaterMark = txManager.getLowWatermark()).keySet())).size() > 1) {
                for (int i = 0; i < oldVersions.size() - 1; ++i) {
                    rowData.remove(oldVersions.get(i));
                }
            }
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    public VersionedCache subCache(Comparable[] from, boolean fromInclusive, Comparable[] to, boolean toInclusive) {
        return new VersionedCache(this.name, (Cache<Comparable[], NavigableMap<Long, VersionedValue>>)this.cache.subCache((Object)from, fromInclusive, (Object)to, toInclusive));
    }

    public KeyValueIterator<Comparable[], List<VersionedValue>> range(Comparable[] from, boolean fromInclusive, Comparable[] to, boolean toInclusive, long minVersion, long maxVersion) {
        return new VersionedKeyValueIterator((KeyValueIterator<Comparable[], NavigableMap<Long, VersionedValue>>)this.cache.range((Object)from, fromInclusive, (Object)to, toInclusive), minVersion, maxVersion);
    }

    public KeyValueIterator<Comparable[], List<VersionedValue>> all(long minVersion, long maxVersion) {
        return new VersionedKeyValueIterator((KeyValueIterator<Comparable[], NavigableMap<Long, VersionedValue>>)this.cache.all(), minVersion, maxVersion);
    }

    public void flush() {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    private static class VersionedKeyValueIterator
    implements KeyValueIterator<Comparable[], List<VersionedValue>> {
        private final KeyValueIterator<Comparable[], NavigableMap<Long, VersionedValue>> rawIterator;
        private final Iterator<KeyValue<Comparable[], List<VersionedValue>>> iterator;

        VersionedKeyValueIterator(KeyValueIterator<Comparable[], NavigableMap<Long, VersionedValue>> iter, long minVersion, long maxVersion) {
            this.rawIterator = iter;
            this.iterator = Streams.streamOf(iter).flatMap(kv -> {
                List values = VersionedCache.getAll((NavigableMap)kv.value, minVersion, maxVersion);
                return values.isEmpty() ? Stream.empty() : Stream.of(new KeyValue(kv.key, (Object)values));
            }).iterator();
        }

        public final boolean hasNext() {
            return this.iterator.hasNext();
        }

        public final KeyValue<Comparable[], List<VersionedValue>> next() {
            return this.iterator.next();
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final void close() {
            this.rawIterator.close();
        }
    }
}

