/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.version;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Striped;
import io.kareldb.transaction.client.KarelDbCellId;
import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.SnapshotFilter;
import io.kareldb.transaction.client.SnapshotFilterImpl;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import io.kcache.utils.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxVersionedCache
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TxVersionedCache.class);
    public static final long INVALID_TX = -1L;
    public static final long PENDING_TX = 0L;
    private final VersionedCache cache;
    private final boolean conflictFree;
    private final SnapshotFilter snapshotFilter;
    private final transient Striped<ReadWriteLock> striped;

    public TxVersionedCache(VersionedCache cache) {
        this(cache, false);
    }

    public TxVersionedCache(VersionedCache cache, boolean conflictFree) {
        this.cache = cache;
        this.conflictFree = conflictFree;
        this.snapshotFilter = new SnapshotFilterImpl(cache);
        this.striped = Striped.readWriteLock((int)128);
    }

    public String getName() {
        return this.cache.getName();
    }

    @VisibleForTesting
    public int size() {
        return Iterators.size(this.all());
    }

    @VisibleForTesting
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public VersionedValue get(Comparable[] key) {
        List<VersionedValue> values = this.getAll(key);
        return values.size() > 0 ? values.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VersionedValue> getAll(Comparable[] key) {
        Lock lock = ((ReadWriteLock)this.striped.get(Arrays.asList(key))).readLock();
        lock.lock();
        try {
            List<VersionedValue> values;
            KarelDbTransaction tx = KarelDbTransaction.currentTransaction();
            List<VersionedValue> list = values = this.snapshotFilter.get(tx, key);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Comparable[] key, Comparable[] value) {
        Lock lock = ((ReadWriteLock)this.striped.get(Arrays.asList(key))).writeLock();
        lock.lock();
        try {
            KarelDbTransaction tx = KarelDbTransaction.currentTransaction();
            List<VersionedValue> values = this.snapshotFilter.get(tx, key);
            if (values.size() > 0) {
                throw new IllegalStateException("Primary key constraint violation: " + Arrays.toString(key));
            }
            this.addWriteSetElement(tx, new KarelDbCellId(this.cache, key, tx.getWriteTimestamp()));
            this.cache.put(key, tx.getWriteTimestamp(), value);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean replace(Comparable[] key, Comparable[] oldValue, Comparable[] newValue) {
        return this.replace(key, oldValue, key, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Comparable[] oldKey, Comparable[] oldValue, Comparable[] newKey, Comparable[] newValue) {
        Iterable locks = this.striped.bulkGet((Iterable)ImmutableList.of(Arrays.asList(oldKey), Arrays.asList(newKey)));
        List<Lock> writeLocks = Streams.streamOf((Iterable)locks).map(ReadWriteLock::writeLock).collect(Collectors.toList());
        writeLocks.forEach(Lock::lock);
        try {
            VersionedValue oldVersionedValue;
            KarelDbTransaction tx = KarelDbTransaction.currentTransaction();
            List<VersionedValue> oldValues = this.snapshotFilter.get(tx, oldKey);
            VersionedValue versionedValue = oldVersionedValue = oldValues.size() > 0 ? oldValues.get(0) : null;
            if (oldVersionedValue == null || !Arrays.equals(oldValue, oldVersionedValue.getValue())) {
                throw new IllegalStateException("Previous value has changed");
            }
            if (Arrays.equals(oldKey, newKey)) {
                this.addWriteSetElement(tx, new KarelDbCellId(this.cache, newKey, tx.getWriteTimestamp()));
                this.cache.put(newKey, tx.getWriteTimestamp(), newValue);
                boolean bl = true;
                return bl;
            }
            List<VersionedValue> newValues = this.snapshotFilter.get(tx, newKey);
            if (newValues.size() > 0) {
                throw new IllegalStateException("Primary key constraint violation: " + Arrays.toString(newKey));
            }
            this.addWriteSetElement(tx, new KarelDbCellId(this.cache, oldKey, tx.getWriteTimestamp()));
            this.addWriteSetElement(tx, new KarelDbCellId(this.cache, newKey, tx.getWriteTimestamp()));
            this.cache.remove(oldKey, tx.getWriteTimestamp());
            this.cache.put(newKey, tx.getWriteTimestamp(), newValue);
            boolean bl = true;
            return bl;
        }
        finally {
            writeLocks.forEach(Lock::unlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Comparable[] key) {
        Lock lock = ((ReadWriteLock)this.striped.get(Arrays.asList(key))).writeLock();
        lock.lock();
        try {
            KarelDbTransaction tx = KarelDbTransaction.currentTransaction();
            this.addWriteSetElement(tx, new KarelDbCellId(this.cache, key, tx.getWriteTimestamp()));
            this.cache.remove(key, tx.getWriteTimestamp());
        }
        finally {
            lock.unlock();
        }
    }

    public TxVersionedCache subCache(Comparable[] from, boolean fromInclusive, Comparable[] to, boolean toInclusive) {
        return new TxVersionedCache(this.cache.subCache(from, fromInclusive, to, toInclusive));
    }

    public KeyValueIterator<Comparable[], VersionedValue> range(Comparable[] from, boolean fromInclusive, Comparable[] to, boolean toInclusive) {
        KarelDbTransaction tx = KarelDbTransaction.currentTransaction();
        return new FlattenedKeyValueIterator(this.snapshotFilter.range(tx, from, fromInclusive, to, toInclusive));
    }

    public KeyValueIterator<Comparable[], VersionedValue> all() {
        KarelDbTransaction tx = KarelDbTransaction.currentTransaction();
        return new FlattenedKeyValueIterator(this.snapshotFilter.all(tx));
    }

    private void addWriteSetElement(KarelDbTransaction transaction, KarelDbCellId cellId) {
        if (this.conflictFree) {
            transaction.addConflictFreeWriteSetElement(cellId);
        } else {
            transaction.addWriteSetElement(cellId);
        }
    }

    public void flush() {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    private static class FlattenedKeyValueIterator
    implements KeyValueIterator<Comparable[], VersionedValue> {
        private final KeyValueIterator<Comparable[], List<VersionedValue>> rawIterator;
        private final Iterator<KeyValue<Comparable[], VersionedValue>> iterator;

        FlattenedKeyValueIterator(KeyValueIterator<Comparable[], List<VersionedValue>> iter) {
            this.rawIterator = iter;
            this.iterator = Streams.streamOf(iter).flatMap(kv -> ((List)kv.value).stream().map(value -> new KeyValue(kv.key, value))).filter(kv -> !((VersionedValue)kv.value).isDeleted()).iterator();
        }

        public final boolean hasNext() {
            return this.iterator.hasNext();
        }

        public final KeyValue<Comparable[], VersionedValue> next() {
            return this.iterator.next();
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final void close() {
            this.rawIterator.close();
        }
    }
}

