/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import io.kareldb.transaction.client.KarelDbCellId;
import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.transaction.client.SnapshotFilter;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.CommitTimestampLocator;
import org.apache.omid.transaction.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFilterImpl
implements SnapshotFilter {
    private static Logger LOG = LoggerFactory.getLogger(SnapshotFilterImpl.class);
    private final VersionedCache versionedCache;

    public SnapshotFilterImpl(VersionedCache versionedCache) {
        this.versionedCache = versionedCache;
    }

    public VersionedCache getVersionedCache() {
        return this.versionedCache;
    }

    private void healShadowCell(KeyValue<Comparable[], VersionedValue> kv, long commitTimestamp) {
        this.versionedCache.setCommit((Comparable[])kv.key, ((VersionedValue)kv.value).getVersion(), commitTimestamp);
    }

    public Optional<CommitTable.CommitTimestamp> readCommitTimestampFromShadowCell(long cellStartTimestamp, CommitTimestampLocator locator) throws IOException {
        Optional commitTS = Optional.absent();
        Optional commitTimestamp = locator.readCommitTimestampFromShadowCell(cellStartTimestamp);
        if (commitTimestamp.isPresent()) {
            commitTS = Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.SHADOW_CELL, ((Long)commitTimestamp.get()).longValue(), true));
        }
        return commitTS;
    }

    public CommitTable.CommitTimestamp locateCellCommitTimestamp(KarelDbTransaction transaction, long cellStartTimestamp, CommitTimestampLocator locator) throws IOException {
        CommitTable.Client commitTableClient = transaction.getTransactionManager().getCommitTableClient();
        long epoch = transaction.getEpoch();
        boolean isLowLatency = transaction.isLowLatency();
        try {
            boolean invalidated;
            Optional<CommitTable.CommitTimestamp> commitTimeStamp;
            Optional commitTimestamp = locator.readCommitTimestampFromCache(cellStartTimestamp);
            if (commitTimestamp.isPresent()) {
                return new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.CACHE, ((Long)commitTimestamp.get()).longValue(), true);
            }
            boolean invalidatedByOther = false;
            Optional commitTimestampFromCT = (Optional)commitTableClient.getCommitTimestamp(cellStartTimestamp).get();
            if (commitTimestampFromCT.isPresent()) {
                if (isLowLatency && !((CommitTable.CommitTimestamp)commitTimestampFromCT.get()).isValid()) {
                    invalidatedByOther = true;
                } else {
                    return (CommitTable.CommitTimestamp)commitTimestampFromCT.get();
                }
            }
            if ((commitTimeStamp = this.readCommitTimestampFromShadowCell(cellStartTimestamp, locator)).isPresent()) {
                return (CommitTable.CommitTimestamp)commitTimeStamp.get();
            }
            if (invalidatedByOther) {
                assert (!((CommitTable.CommitTimestamp)commitTimestampFromCT.get()).isValid());
                return (CommitTable.CommitTimestamp)commitTimestampFromCT.get();
            }
            if ((cellStartTimestamp < epoch || isLowLatency) && (invalidated = ((Boolean)commitTableClient.tryInvalidateTransaction(cellStartTimestamp).get()).booleanValue())) {
                if (isLowLatency && (commitTimeStamp = this.readCommitTimestampFromShadowCell(cellStartTimestamp, locator)).isPresent()) {
                    commitTableClient.deleteCommitEntry(cellStartTimestamp);
                    return (CommitTable.CommitTimestamp)commitTimeStamp.get();
                }
                return new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, -1L, false);
            }
            commitTimeStamp = (Optional<CommitTable.CommitTimestamp>)commitTableClient.getCommitTimestamp(cellStartTimestamp).get();
            if (commitTimeStamp.isPresent()) {
                return (CommitTable.CommitTimestamp)commitTimeStamp.get();
            }
            commitTimeStamp = this.readCommitTimestampFromShadowCell(cellStartTimestamp, locator);
            if (commitTimeStamp.isPresent()) {
                return (CommitTable.CommitTimestamp)commitTimeStamp.get();
            }
            return new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.NOT_PRESENT, -1L, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while finding commit timestamp", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Problem finding commit timestamp", e);
        }
    }

    public Optional<Long> tryToLocateCellCommitTimestamp(KarelDbTransaction transaction, KeyValue<Comparable[], VersionedValue> cell, Map<Long, Long> commitCache) throws IOException {
        CommitTable.CommitTimestamp tentativeCommitTimestamp = this.locateCellCommitTimestamp(transaction, ((VersionedValue)cell.value).getVersion(), new KarelDbTransactionManager.CommitTimestampLocatorImpl(new KarelDbCellId(this.versionedCache, (Comparable[])cell.key, ((VersionedValue)cell.value).getVersion()), commitCache, this.versionedCache));
        if (!tentativeCommitTimestamp.isValid()) {
            return Optional.absent();
        }
        switch (tentativeCommitTimestamp.getLocation()) {
            case COMMIT_TABLE: {
                this.healShadowCell(cell, tentativeCommitTimestamp.getValue());
                return Optional.of((Object)tentativeCommitTimestamp.getValue());
            }
            case CACHE: 
            case SHADOW_CELL: {
                return Optional.of((Object)tentativeCommitTimestamp.getValue());
            }
            case NOT_PRESENT: {
                return Optional.absent();
            }
        }
        assert (false);
        return Optional.absent();
    }

    private Optional<Long> getCommitTimestamp(KarelDbTransaction transaction, KeyValue<Comparable[], VersionedValue> kv, Map<Long, Long> commitCache) throws IOException {
        long startTimestamp = transaction.getStartTimestamp();
        if (((VersionedValue)kv.value).getVersion() == startTimestamp) {
            return Optional.of((Object)startTimestamp);
        }
        return this.tryToLocateCellCommitTimestamp(transaction, kv, commitCache);
    }

    private Map<Long, Long> buildCommitCache(List<VersionedValue> rawCells) {
        HashMap<Long, Long> commitCache = new HashMap<Long, Long>();
        for (VersionedValue value : rawCells) {
            long commit = value.getCommit();
            if (commit <= 0L) continue;
            commitCache.put(value.getVersion(), commit);
        }
        return commitCache;
    }

    public Optional<Long> getTSIfInTransaction(KarelDbTransaction transaction, KeyValue<Comparable[], VersionedValue> kv) {
        long startTimestamp = transaction.getStartTimestamp();
        long readTimestamp = transaction.getReadTimestamp();
        if (((VersionedValue)kv.value).getVersion() >= startTimestamp && ((VersionedValue)kv.value).getVersion() <= readTimestamp) {
            return Optional.of((Object)((VersionedValue)kv.value).getVersion());
        }
        return Optional.absent();
    }

    public Optional<Long> getTSIfInSnapshot(KarelDbTransaction transaction, KeyValue<Comparable[], VersionedValue> kv, Map<Long, Long> commitCache) throws IOException {
        Optional<Long> commitTimestamp = this.getCommitTimestamp(transaction, kv, commitCache);
        if (commitTimestamp.isPresent() && (Long)commitTimestamp.get() < transaction.getStartTimestamp()) {
            return commitTimestamp;
        }
        return Optional.absent();
    }

    public List<VersionedValue> filterCellsForSnapshot(KarelDbTransaction transaction, Comparable[] key, List<VersionedValue> rawCells) throws IOException {
        assert (rawCells != null && transaction != null);
        ArrayList<VersionedValue> keyValuesInSnapshot = new ArrayList<VersionedValue>();
        Map<Long, Long> commitCache = this.buildCommitCache(rawCells);
        for (VersionedValue value : rawCells) {
            KeyValue kv = new KeyValue((Object)key, (Object)value);
            if (!this.getTSIfInTransaction(transaction, (KeyValue<Comparable[], VersionedValue>)kv).isPresent() && !this.getTSIfInSnapshot(transaction, (KeyValue<Comparable[], VersionedValue>)kv, commitCache).isPresent()) continue;
            if (transaction.getVisibilityLevel() == AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL) {
                keyValuesInSnapshot.add(value);
                if (!this.getTSIfInTransaction(transaction, (KeyValue<Comparable[], VersionedValue>)kv).isPresent()) break;
                continue;
            }
            keyValuesInSnapshot.add(value);
            break;
        }
        return keyValuesInSnapshot;
    }

    @Override
    public List<VersionedValue> get(KarelDbTransaction transaction, Comparable[] key) {
        try {
            List<VersionedValue> result = this.versionedCache.get(key, 0L, Long.MAX_VALUE);
            List<VersionedValue> filteredKeyValues = Collections.emptyList();
            if (!result.isEmpty()) {
                filteredKeyValues = this.filterCellsForSnapshot(transaction, key, result);
            }
            return filteredKeyValues;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public KeyValueIterator<Comparable[], List<VersionedValue>> range(KarelDbTransaction transaction, Comparable[] from, boolean fromInclusive, Comparable[] to, boolean toInclusive) {
        return new FilteredKeyValueIterator(transaction, this.versionedCache.range(from, fromInclusive, to, toInclusive, 0L, Long.MAX_VALUE));
    }

    @Override
    public KeyValueIterator<Comparable[], List<VersionedValue>> all(KarelDbTransaction transaction) {
        return new FilteredKeyValueIterator(transaction, this.versionedCache.all(0L, Long.MAX_VALUE));
    }

    @VisibleForTesting
    public boolean isCommitted(KarelDbTransaction transaction, KarelDbCellId cellId) throws TransactionException {
        try {
            long timestamp = cellId.getTimestamp();
            CommitTable.CommitTimestamp tentativeCommitTimestamp = this.locateCellCommitTimestamp(transaction, timestamp, new KarelDbTransactionManager.CommitTimestampLocatorImpl(cellId, Maps.newHashMap(), this.versionedCache));
            if (!tentativeCommitTimestamp.isValid()) {
                return false;
            }
            switch (tentativeCommitTimestamp.getLocation()) {
                case COMMIT_TABLE: 
                case SHADOW_CELL: {
                    return true;
                }
                case NOT_PRESENT: {
                    return false;
                }
            }
            return false;
        }
        catch (IOException e) {
            throw new TransactionException("Failure while checking if a transaction was committed", (Throwable)e);
        }
    }

    private class FilteredKeyValueIterator
    implements KeyValueIterator<Comparable[], List<VersionedValue>> {
        private final KarelDbTransaction transaction;
        private final KeyValueIterator<Comparable[], List<VersionedValue>> iterator;

        FilteredKeyValueIterator(KarelDbTransaction transaction, KeyValueIterator<Comparable[], List<VersionedValue>> iter) {
            this.transaction = transaction;
            this.iterator = iter;
        }

        public final boolean hasNext() {
            return this.iterator.hasNext();
        }

        public final KeyValue<Comparable[], List<VersionedValue>> next() {
            try {
                KeyValue next = (KeyValue)this.iterator.next();
                return new KeyValue(next.key, SnapshotFilterImpl.this.filterCellsForSnapshot(this.transaction, (Comparable[])next.key, (List)next.value));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final void close() {
            this.iterator.close();
        }
    }
}

