/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import com.google.common.base.Optional;
import io.kareldb.transaction.InMemoryCommitTable;
import io.kareldb.transaction.InMemoryTimestampStorage;
import io.kareldb.transaction.KarelDbTimestampClient;
import io.kareldb.transaction.client.KarelDbCellId;
import io.kareldb.transaction.client.KarelDbSyncPostCommitter;
import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.AbstractTransactionManager;
import org.apache.omid.transaction.AbstractTransactionManagerShim;
import org.apache.omid.transaction.CommitTimestampLocator;
import org.apache.omid.transaction.PostCommitActions;
import org.apache.omid.transaction.TransactionException;
import org.apache.omid.transaction.TransactionManagerException;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.TSOProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarelDbTransactionManager
extends AbstractTransactionManagerShim {
    private static final Logger LOG = LoggerFactory.getLogger(KarelDbTransactionManager.class);

    public static KarelDbTransactionManager newInstance() {
        return KarelDbTransactionManager.newInstance(new InMemoryCommitTable(), new InMemoryTimestampStorage());
    }

    public static KarelDbTransactionManager newInstance(CommitTable commitTable, TimestampStorage timestampStorage) {
        try {
            NullMetricsProvider metricsRegistry = new NullMetricsProvider();
            TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)metricsRegistry, timestampStorage, (Panicker)new RuntimeExceptionPanicker());
            timestampOracle.initialize();
            KarelDbSyncPostCommitter postCommitter = new KarelDbSyncPostCommitter(commitTable.getClient());
            return KarelDbTransactionManager.newInstance(commitTable, (TimestampOracle)timestampOracle, (PostCommitActions)postCommitter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KarelDbTransactionManager newInstance(CommitTable commitTable, TimestampStorage timestampStorage, PostCommitActions postCommitter) {
        try {
            NullMetricsProvider metricsRegistry = new NullMetricsProvider();
            CommitTable.Client commitTableClient = commitTable.getClient();
            CommitTable.Writer commitTableWriter = commitTable.getWriter();
            TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)metricsRegistry, timestampStorage, (Panicker)new RuntimeExceptionPanicker());
            timestampOracle.initialize();
            KarelDbTimestampClient tsoClient = new KarelDbTimestampClient((TimestampOracle)timestampOracle, commitTableWriter);
            return new KarelDbTransactionManager((MetricsRegistry)metricsRegistry, postCommitter, (TSOProtocol)tsoClient, commitTableClient, commitTableWriter, new KarelDbTransactionFactory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KarelDbTransactionManager newInstance(CommitTable commitTable, TimestampOracle timestampOracle, PostCommitActions postCommitter) {
        try {
            NullMetricsProvider metricsRegistry = new NullMetricsProvider();
            CommitTable.Client commitTableClient = commitTable.getClient();
            CommitTable.Writer commitTableWriter = commitTable.getWriter();
            KarelDbTimestampClient tsoClient = new KarelDbTimestampClient(timestampOracle, commitTableWriter);
            return new KarelDbTransactionManager((MetricsRegistry)metricsRegistry, postCommitter, (TSOProtocol)tsoClient, commitTableClient, commitTableWriter, new KarelDbTransactionFactory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private KarelDbTransactionManager(MetricsRegistry metricsRegistry, PostCommitActions postCommitter, TSOProtocol tsoClient, CommitTable.Client commitTableClient, CommitTable.Writer commitTableWriter, KarelDbTransactionFactory transactionFactory) {
        super(metricsRegistry, postCommitter, tsoClient, commitTableClient, commitTableWriter, transactionFactory);
    }

    public void postBegin(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)transaction);
    }

    @Override
    public void closeResources() throws IOException {
    }

    public long getHashForTable(byte[] tableName) {
        return KarelDbCellId.getHasher().putBytes(tableName).hash().asLong();
    }

    public long getLowWatermark() throws TransactionException {
        try {
            return (Long)this.commitTableClient.readLowWatermark().get();
        }
        catch (ExecutionException ee) {
            throw new TransactionException("Error reading low watermark", ee.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new TransactionException("Interrupted reading low watermark", (Throwable)ie);
        }
    }

    public static KarelDbTransaction enforceKarelDbTransactionAsParam(AbstractTransaction<? extends CellId> tx) {
        if (tx instanceof KarelDbTransaction) {
            return (KarelDbTransaction)tx;
        }
        throw new IllegalArgumentException("The transaction object passed is not an instance of KarelDBTransaction");
    }

    public static class CommitTimestampLocatorImpl
    implements CommitTimestampLocator {
        private final KarelDbCellId cellId;
        private final Map<Long, Long> commitCache;
        private final VersionedCache versionedCache;

        public CommitTimestampLocatorImpl(KarelDbCellId cellId, Map<Long, Long> commitCache, VersionedCache versionedCache) {
            this.cellId = cellId;
            this.commitCache = commitCache;
            this.versionedCache = versionedCache;
        }

        public Optional<Long> readCommitTimestampFromCache(long startTimestamp) {
            return Optional.fromNullable((Object)this.commitCache.get(startTimestamp));
        }

        public Optional<Long> readCommitTimestampFromShadowCell(long startTimestamp) throws IOException {
            VersionedValue value = this.versionedCache.get(this.cellId.getKey(), startTimestamp);
            if (value == null) {
                return Optional.absent();
            }
            long commit = value.getCommit();
            return Optional.fromNullable((Object)(commit > 0L ? Long.valueOf(commit) : null));
        }
    }

    private static class KarelDbTransactionFactory
    implements AbstractTransactionManager.TransactionFactory<KarelDbCellId> {
        private KarelDbTransactionFactory() {
        }

        public KarelDbTransaction createTransaction(long transactionId, long epoch, AbstractTransactionManager tm) {
            return new KarelDbTransaction(transactionId, epoch, new HashSet<KarelDbCellId>(), new HashSet<KarelDbCellId>(), tm, tm.isLowLatency());
        }
    }
}

