/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbCellId;
import io.kareldb.version.VersionedCache;
import java.util.HashMap;
import java.util.Set;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.AbstractTransactionManager;
import org.apache.omid.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarelDbTransaction
extends AbstractTransaction<KarelDbCellId> {
    private static final Logger LOG = LoggerFactory.getLogger(KarelDbTransaction.class);
    private static final ThreadLocal<KarelDbTransaction> currentTransaction = new ThreadLocal();

    public static KarelDbTransaction currentTransaction() {
        KarelDbTransaction transaction = currentTransaction.get();
        if (transaction == null) {
            throw new IllegalStateException("No current transaction");
        }
        if (transaction.getStatus() == Transaction.Status.ROLLEDBACK) {
            throw new IllegalStateException("Transaction was already " + transaction.getStatus());
        }
        return transaction;
    }

    public static void setCurrentTransaction(KarelDbTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("No current transaction");
        }
        if (transaction.getStatus() != Transaction.Status.RUNNING) {
            throw new IllegalArgumentException("Transaction was already " + transaction.getStatus());
        }
        currentTransaction.set(transaction);
    }

    public KarelDbTransaction(long transactionId, long epoch, Set<KarelDbCellId> writeSet, Set<KarelDbCellId> conflictFreeWriteSet, AbstractTransactionManager tm, boolean isLowLatency) {
        super(transactionId, epoch, writeSet, conflictFreeWriteSet, tm, isLowLatency);
    }

    public KarelDbTransaction(long transactionId, long epoch, Set<KarelDbCellId> writeSet, Set<KarelDbCellId> conflictFreeWriteSet, AbstractTransactionManager tm, long readTimestamp, long writeTimestamp, boolean isLowLatency) {
        super(transactionId, epoch, writeSet, conflictFreeWriteSet, tm, readTimestamp, writeTimestamp, isLowLatency);
    }

    public KarelDbTransaction(long transactionId, long readTimestamp, AbstractTransaction.VisibilityLevel visibilityLevel, long epoch, Set<KarelDbCellId> writeSet, Set<KarelDbCellId> conflictFreeWriteSet, AbstractTransactionManager tm, boolean isLowLatency) {
        super(transactionId, readTimestamp, visibilityLevel, epoch, writeSet, conflictFreeWriteSet, tm, isLowLatency);
    }

    public void cleanup() {
        try {
            VersionedCache cache;
            HashMap<String, VersionedCache> caches = new HashMap<String, VersionedCache>();
            for (KarelDbCellId cell : this.getWriteSet()) {
                cache = cell.getCache();
                caches.put(cache.getName(), cache);
                cache.setCommit(cell.getKey(), cell.getTimestamp(), -1L);
            }
            for (KarelDbCellId cell : this.getConflictFreeWriteSet()) {
                cache = cell.getCache();
                caches.put(cache.getName(), cache);
                cache.setCommit(cell.getKey(), cell.getTimestamp(), -1L);
            }
            for (VersionedCache cache2 : caches.values()) {
                cache2.flush();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed cleanup for Tx {}. This issue has been ignored", (Object)this.getTransactionId(), (Object)e);
        }
    }
}

