/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.kareldb.transaction.client.KarelDbCellId;
import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.VersionedCache;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.PostCommitActions;
import org.apache.omid.transaction.TransactionManagerException;
import org.apache.omid.tso.client.CellId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarelDbSyncPostCommitter
implements PostCommitActions {
    private static final Logger LOG = LoggerFactory.getLogger(KarelDbSyncPostCommitter.class);
    private final CommitTable.Client commitTableClient;

    public KarelDbSyncPostCommitter(CommitTable.Client commitTableClient) {
        this.commitTableClient = commitTableClient;
    }

    public ListenableFuture<Void> updateShadowCells(AbstractTransaction<? extends CellId> transaction) {
        SettableFuture updateSCFuture = SettableFuture.create();
        KarelDbTransaction tx = KarelDbTransactionManager.enforceKarelDbTransactionAsParam(transaction);
        try {
            VersionedCache cache;
            HashMap<String, VersionedCache> caches = new HashMap<String, VersionedCache>();
            for (KarelDbCellId cell : tx.getWriteSet()) {
                cache = cell.getCache();
                caches.put(cache.getName(), cache);
                cache.setCommit(cell.getKey(), cell.getTimestamp(), tx.getCommitTimestamp());
            }
            for (KarelDbCellId cell : tx.getConflictFreeWriteSet()) {
                cache = cell.getCache();
                caches.put(cache.getName(), cache);
                cache.setCommit(cell.getKey(), cell.getTimestamp(), tx.getCommitTimestamp());
            }
            for (VersionedCache cache2 : caches.values()) {
                cache2.flush();
            }
            updateSCFuture.set(null);
        }
        catch (Exception e) {
            LOG.warn("{}: Error inserting shadow cells", (Object)tx, (Object)e);
            updateSCFuture.setException((Throwable)new TransactionManagerException((Object)((Object)tx) + ": Error inserting shadow cells ", (Throwable)e));
        }
        return updateSCFuture;
    }

    public ListenableFuture<Void> removeCommitTableEntry(AbstractTransaction<? extends CellId> transaction) {
        SettableFuture updateSCFuture = SettableFuture.create();
        KarelDbTransaction tx = KarelDbTransactionManager.enforceKarelDbTransactionAsParam(transaction);
        try {
            this.commitTableClient.deleteCommitEntry(tx.getStartTimestamp()).get();
            updateSCFuture.set(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("{}: interrupted during commit table entry delete", (Object)tx, (Object)e);
            updateSCFuture.setException((Throwable)new TransactionManagerException((Object)((Object)tx) + ": interrupted during commit table entry delete"));
        }
        catch (ExecutionException e) {
            LOG.warn("{}: can't remove commit table entry", (Object)tx, (Object)e);
            updateSCFuture.setException((Throwable)new TransactionManagerException((Object)((Object)tx) + ": can't remove commit table entry"));
        }
        return updateSCFuture;
    }
}

