/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import com.google.common.base.Charsets;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import io.kareldb.version.VersionedCache;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.omid.tso.client.CellId;

public class KarelDbCellId
implements CellId {
    private final VersionedCache cache;
    private final Comparable[] key;
    private final long timestamp;

    public KarelDbCellId(VersionedCache cache, Comparable[] key, long timestamp) {
        this.timestamp = timestamp;
        this.cache = cache;
        this.key = key;
    }

    public VersionedCache getCache() {
        return this.cache;
    }

    public Comparable[] getKey() {
        return this.key;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.cache.getName() + ":" + Arrays.toString(this.key) + ":" + this.timestamp;
    }

    public long getCellId() {
        return KarelDbCellId.getHasher().putBytes(this.cache.getName().getBytes(Charsets.UTF_8)).putObject((Object)this.key, (Funnel)new ComparableArrayFunnel()).hash().asLong();
    }

    public long getTableId() {
        return KarelDbCellId.getHasher().putBytes(this.cache.getName().getBytes(Charsets.UTF_8)).hash().asLong();
    }

    public long getRowId() {
        return KarelDbCellId.getHasher().putBytes(this.cache.getName().getBytes(Charsets.UTF_8)).putObject((Object)this.key, (Funnel)new ComparableArrayFunnel()).hash().asLong();
    }

    public static Hasher getHasher() {
        return Hashing.murmur3_128().newHasher();
    }

    static class ComparableArrayFunnel
    implements Funnel<Comparable[]> {
        ComparableArrayFunnel() {
        }

        public void funnel(Comparable[] array, PrimitiveSink into) {
            for (Comparable c : array) {
                if (c instanceof Boolean) {
                    into.putBoolean(((Boolean)c).booleanValue());
                    continue;
                }
                if (c instanceof Integer) {
                    into.putInt(((Integer)c).intValue());
                    continue;
                }
                if (c instanceof Long) {
                    into.putLong(((Long)c).longValue());
                    continue;
                }
                if (c instanceof Float) {
                    into.putFloat(((Float)c).floatValue());
                    continue;
                }
                if (c instanceof Double) {
                    into.putDouble(((Double)c).doubleValue());
                    continue;
                }
                if (c instanceof ByteString) {
                    into.putBytes(((ByteString)c).getBytes());
                    continue;
                }
                if (c instanceof String) {
                    into.putString((CharSequence)((String)((Object)c)), Charsets.UTF_8);
                    continue;
                }
                if (c instanceof BigDecimal) {
                    into.putDouble(((BigDecimal)c).doubleValue());
                    continue;
                }
                if (c instanceof Date) {
                    into.putLong(((Date)c).getTime());
                    continue;
                }
                if (c instanceof Time) {
                    into.putLong(((Time)c).getTime());
                    continue;
                }
                if (c instanceof Timestamp) {
                    into.putLong(((Timestamp)c).getTime());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported object of type " + c.getClass().getName());
            }
        }
    }
}

