/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import io.kcache.Cache;
import java.io.IOException;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarelDbTimestampStorage
implements TimestampStorage {
    private static final long INITIAL_MAX_TS_VALUE = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(KarelDbTimestampStorage.class);
    private static final long TSO_KEY = -1L;
    private final Cache<Long, Long> cache;

    public KarelDbTimestampStorage(Cache<Long, Long> cache) {
        this.cache = cache;
    }

    public void updateMaxTimestamp(long previousMaxTimestamp, long newMaxTimestamp) throws IOException {
        if (newMaxTimestamp < 0L) {
            LOG.error("Negative value received for maxTimestamp: {}", (Object)newMaxTimestamp);
            throw new IllegalArgumentException("Negative value received for maxTimestamp " + newMaxTimestamp);
        }
        boolean updated = previousMaxTimestamp == 0L ? this.cache.putIfAbsent((Object)-1L, (Object)newMaxTimestamp) == null : this.cache.replace((Object)-1L, (Object)previousMaxTimestamp, (Object)newMaxTimestamp);
        this.cache.flush();
        if (!updated) {
            throw new IOException("Previous max timestamp is incorrect");
        }
    }

    public long getMaxTimestamp() {
        return (Long)this.cache.getOrDefault((Object)-1L, (Object)0L);
    }
}

