/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.kcache.Cache;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.omid.committable.CommitTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarelDbCommitTable
implements CommitTable {
    private static final Logger LOG = LoggerFactory.getLogger(KarelDbCommitTable.class);
    private static final long LOW_WATERMARK_KEY = 0L;
    private final Cache<Long, Long> cache;

    public KarelDbCommitTable(Cache<Long, Long> cache) {
        this.cache = cache;
    }

    public CommitTable.Writer getWriter() throws IOException {
        return new KarelDbWriter();
    }

    public CommitTable.Client getClient() throws IOException {
        return new KarelDbClient();
    }

    static long removeCheckpointBits(long startTimestamp) {
        return startTimestamp - startTimestamp % 50L;
    }

    class KarelDbClient
    implements CommitTable.Client {
        KarelDbClient() {
        }

        public ListenableFuture<Optional<CommitTable.CommitTimestamp>> getCommitTimestamp(long startTimestamp) {
            startTimestamp = KarelDbCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            Long commitTimestamp = (Long)KarelDbCommitTable.this.cache.get((Object)startTimestamp);
            if (commitTimestamp == null) {
                f.set((Object)Optional.absent());
            } else {
                if (commitTimestamp == -1L) {
                    CommitTable.CommitTimestamp invalidCT = new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, -1L, false);
                    f.set((Object)Optional.of((Object)invalidCT));
                    return f;
                }
                CommitTable.CommitTimestamp validCT = new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, commitTimestamp.longValue(), true);
                f.set((Object)Optional.of((Object)validCT));
            }
            return f;
        }

        public ListenableFuture<Long> readLowWatermark() {
            SettableFuture f = SettableFuture.create();
            Long lowWatermark = (Long)KarelDbCommitTable.this.cache.get((Object)0L);
            if (lowWatermark == null) {
                f.set((Object)0L);
            } else {
                f.set((Object)lowWatermark);
            }
            return f;
        }

        public ListenableFuture<Void> deleteCommitEntry(long startTimestamp) {
            startTimestamp = KarelDbCommitTable.removeCheckpointBits(startTimestamp);
            KarelDbCommitTable.this.cache.remove((Object)startTimestamp);
            KarelDbCommitTable.this.cache.flush();
            SettableFuture f = SettableFuture.create();
            f.set(null);
            return f;
        }

        public ListenableFuture<Boolean> tryInvalidateTransaction(long startTimestamp) {
            startTimestamp = KarelDbCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            Long value = (Long)KarelDbCommitTable.this.cache.putIfAbsent((Object)startTimestamp, (Object)-1L);
            KarelDbCommitTable.this.cache.flush();
            f.set((Object)(value == null || value == -1L ? 1 : 0));
            return f;
        }
    }

    private class KarelDbWriter
    implements CommitTable.Writer {
        private static final long INITIAL_LWM_VALUE = -1L;
        final Map<Long, Long> writeBuffer = new ConcurrentHashMap<Long, Long>();
        volatile long lowWatermarkToStore = -1L;

        KarelDbWriter() {
        }

        public void addCommittedTransaction(long startTimestamp, long commitTimestamp) throws IOException {
            assert (startTimestamp <= commitTimestamp);
            this.writeBuffer.put(startTimestamp, commitTimestamp);
        }

        public void updateLowWatermark(long lowWatermark) throws IOException {
            this.lowWatermarkToStore = lowWatermark;
        }

        public void flush() throws IOException {
            this.addLowWatermarkToStoreToWriteBuffer();
            for (Map.Entry<Long, Long> entry : this.writeBuffer.entrySet()) {
                KarelDbCommitTable.this.cache.merge((Object)entry.getKey(), (Object)entry.getValue(), (oldValue, newValue) -> oldValue != -1L ? newValue : oldValue);
            }
            KarelDbCommitTable.this.cache.flush();
            this.writeBuffer.clear();
        }

        public void clearWriteBuffer() {
            this.writeBuffer.clear();
        }

        public boolean atomicAddCommittedTransaction(long startTimestamp, long commitTimestamp) throws IOException {
            assert (startTimestamp < commitTimestamp);
            long value = (Long)KarelDbCommitTable.this.cache.merge((Object)startTimestamp, (Object)commitTimestamp, (oldValue, newValue) -> oldValue != -1L ? newValue : oldValue);
            KarelDbCommitTable.this.cache.flush();
            return value != -1L;
        }

        private void addLowWatermarkToStoreToWriteBuffer() {
            long lowWatermark = this.lowWatermarkToStore;
            if (lowWatermark != -1L) {
                this.writeBuffer.put(0L, lowWatermark);
            }
        }
    }
}

