/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.omid.committable.CommitTable;

public class InMemoryCommitTable
implements CommitTable {
    private final ConcurrentHashMap<Long, Long> table = new ConcurrentHashMap();
    private long lowWatermark;

    public CommitTable.Writer getWriter() {
        return new Writer();
    }

    public CommitTable.Client getClient() {
        return new Client();
    }

    public int countElements() {
        return this.table.size();
    }

    private static long removeCheckpointBits(long startTimestamp) {
        return startTimestamp - startTimestamp % 50L;
    }

    public class Client
    implements CommitTable.Client {
        public ListenableFuture<Optional<CommitTable.CommitTimestamp>> getCommitTimestamp(long startTimestamp) {
            startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            Long result = (Long)InMemoryCommitTable.this.table.get(startTimestamp);
            if (result == null) {
                f.set((Object)Optional.absent());
            } else if (result == -1L) {
                f.set((Object)Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, -1L, false)));
            } else {
                f.set((Object)Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, result.longValue(), true)));
            }
            return f;
        }

        public ListenableFuture<Long> readLowWatermark() {
            SettableFuture f = SettableFuture.create();
            f.set((Object)InMemoryCommitTable.this.lowWatermark);
            return f;
        }

        public ListenableFuture<Void> deleteCommitEntry(long startTimestamp) {
            startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            InMemoryCommitTable.this.table.remove(startTimestamp);
            f.set(null);
            return f;
        }

        public ListenableFuture<Boolean> tryInvalidateTransaction(long startTimestamp) {
            startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            Long old = (Long)InMemoryCommitTable.this.table.get(startTimestamp);
            if (old == null) {
                old = InMemoryCommitTable.this.table.putIfAbsent(startTimestamp, -1L);
                if (old == null || old == -1L) {
                    f.set((Object)true);
                    return f;
                }
            } else if (old == -1L) {
                f.set((Object)true);
                return f;
            }
            f.set((Object)false);
            return f;
        }
    }

    public class Writer
    implements CommitTable.Writer {
        public void addCommittedTransaction(long startTimestamp, long commitTimestamp) {
            InMemoryCommitTable.this.table.putIfAbsent(startTimestamp, commitTimestamp);
        }

        public void updateLowWatermark(long lowWatermark) throws IOException {
            InMemoryCommitTable.this.lowWatermark = lowWatermark;
        }

        public void flush() throws IOException {
        }

        public void clearWriteBuffer() {
            InMemoryCommitTable.this.table.clear();
        }

        public boolean atomicAddCommittedTransaction(long startTimestamp, long commitTimestamp) throws IOException {
            startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp);
            return InMemoryCommitTable.this.table.putIfAbsent(startTimestamp, commitTimestamp) == null;
        }
    }
}

