/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.schema;

import io.kareldb.schema.Table;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.linq4j.Enumerator;

class TableEnumerator<E>
implements Enumerator<E> {
    private final Iterator<?> rows;
    private final AtomicBoolean cancelFlag;
    private final boolean alwaysReturnArray;
    private E current;

    TableEnumerator(Iterator<?> rows, AtomicBoolean cancelFlag, boolean alwaysReturnArray) {
        this.rows = rows;
        this.cancelFlag = cancelFlag;
        this.alwaysReturnArray = alwaysReturnArray;
    }

    public E current() {
        return this.current;
    }

    public boolean moveNext() {
        Object[] row;
        if (this.cancelFlag.get()) {
            return false;
        }
        Object[] objectArray = row = this.rows.hasNext() ? Table.toArray(this.rows.next()) : null;
        if (row == null) {
            this.current = null;
            return false;
        }
        this.current = this.convertRow(row);
        return true;
    }

    private E convertRow(Object[] row) {
        return (E)(this.alwaysReturnArray || row.length > 1 ? row : row[0]);
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

