/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.schema;

import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.Iterators;
import io.kareldb.schema.RelDef;
import io.kareldb.schema.Schema;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import io.kcache.KeyValue;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.util.Pair;

public abstract class Table
extends AbstractQueryableTable
implements ModifiableTable,
Closeable {
    public static final Comparable[] EMPTY_VALUE = new Comparable[0];
    private final Schema schema;
    private final String name;
    private RelDef relDef;
    private Map<String, Object> configs;
    private int[] permutationIndices;
    private int[] inverseIndices;

    Table(Schema schema, String name, RelDef relDef) {
        super(Object[].class);
        this.schema = schema;
        this.name = name;
        this.setRelDef(relDef);
    }

    public void configure(Map<String, ?> configs) {
        this.configs = configs;
    }

    public abstract void init();

    public abstract void sync();

    public Schema getSchema() {
        return this.schema;
    }

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public int[] getKeyIndices() {
        return Arrays.copyOf(this.getPermutationIndices(), this.getRelDef().getKeyFields().size());
    }

    private int[] getPermutationIndices() {
        if (this.permutationIndices == null) {
            int size = this.size();
            int[] result = new int[size];
            HashSet<Integer> keyIndices = new HashSet<Integer>();
            int index = 0;
            for (String keyField : this.getRelDef().getKeyFields()) {
                keyIndices.add(index);
                result[index++] = this.getRelDef().getRowType().getField(keyField, true, false).getIndex();
            }
            for (int i = 0; i < size; ++i) {
                if (keyIndices.contains(i)) continue;
                result[index++] = i;
            }
            this.permutationIndices = result;
        }
        return this.permutationIndices;
    }

    private int[] getInverseIndices() {
        if (this.inverseIndices == null) {
            int[] permutation = this.getPermutationIndices();
            int size = this.size();
            int[] result = new int[size];
            for (int i = 0; i < size; ++i) {
                result[permutation[i]] = i;
            }
            this.inverseIndices = result;
        }
        return this.inverseIndices;
    }

    public int size() {
        return this.getRowType().getFieldCount();
    }

    public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        return LogicalTableModify.create((RelOptTable)table, (Prepare.CatalogReader)catalogReader, (RelNode)child, (TableModify.Operation)operation, updateColumnList, sourceExpressionList, (boolean)flattened);
    }

    public Collection getModifiableCollection() {
        return new CacheWrapper(this.getRows());
    }

    protected abstract VersionedCache getRows();

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                return Linq4j.iterableEnumerator(() -> Iterators.transform(Table.this.getModifiableCollection().iterator(), Table::toArray));
            }
        };
    }

    public static Object[] toArray(Object o) {
        Object[] objectArray;
        if (o.getClass().isArray()) {
            objectArray = (Comparable[])o;
        } else {
            Comparable[] comparableArray = new Comparable[1];
            objectArray = comparableArray;
            comparableArray[0] = (Comparable)o;
        }
        return objectArray;
    }

    public String getName() {
        return this.name;
    }

    public RelDef getRelDef() {
        return this.relDef;
    }

    public void setRelDef(RelDef relDef) {
        this.relDef = relDef;
        this.permutationIndices = null;
        this.inverseIndices = null;
    }

    public RelDataType getRowType() {
        return this.getRelDef().getRowType();
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.getRelDef() == null) {
            return null;
        }
        RelProtoDataType protoRowType = RelDataTypeImpl.proto((RelDataType)this.getRowType());
        return (RelDataType)protoRowType.apply((Object)typeFactory);
    }

    public static int[] identityList(int n) {
        int[] integers = new int[n];
        for (int i = 0; i < n; ++i) {
            integers[i] = i;
        }
        return integers;
    }

    public Pair<Comparable[], Comparable[]> toKeyValue(Object o) {
        int i;
        if (!o.getClass().isArray()) {
            return new Pair((Object)new Comparable[]{(Comparable)o}, (Object)EMPTY_VALUE);
        }
        Object[] objs = (Object[])o;
        int size = this.size();
        int keySize = this.getRelDef().getKeyFields().size();
        int valueSize = size - keySize;
        Comparable[] keys = new Comparable[keySize];
        Comparable[] values = new Comparable[valueSize];
        int[] permutation = this.getPermutationIndices();
        int index = 0;
        for (i = 0; i < keySize; ++i) {
            keys[index++] = (Comparable)objs[permutation[i]];
        }
        index = 0;
        for (i = keySize; i < size; ++i) {
            values[index++] = (Comparable)objs[permutation[i]];
        }
        return new Pair((Object)keys, (Object)values);
    }

    public Object toRow(KeyValue<Comparable[], VersionedValue> entry) {
        Comparable[] key = (Comparable[])entry.key;
        Comparable[] values = ((VersionedValue)entry.value).getValue();
        if (key.length == 1 && values.length == 0) {
            return key[0];
        }
        int[] inverse = this.getInverseIndices();
        Comparable[] row = new Comparable[inverse.length];
        for (int i = 0; i < inverse.length; ++i) {
            int index = inverse[i];
            int valueIndex = index - key.length;
            row[i] = index < key.length ? key[index] : (valueIndex < values.length ? values[valueIndex] : null);
        }
        return row;
    }

    class SetWrapper
    extends ForwardingSortedSet
    implements CollectionWrapper {
        private final SortedSet delegate;

        public SetWrapper() {
            this(new TreeSet<Comparable[]>(new ComparableArrayComparator()));
        }

        protected SetWrapper(SortedSet delegate) {
            this.delegate = delegate;
        }

        protected SortedSet delegate() {
            return this.delegate;
        }

        @Override
        public Iterator iterator() {
            return Iterators.transform(this.delegate.iterator(), o -> o.getClass().isArray() && ((Comparable[])o).length == 1 ? ((Comparable[])o)[0] : o);
        }

        @Override
        public CollectionWrapper singleton(Comparable[] key) {
            SetWrapper singleton = new SetWrapper();
            if (this.contains(key)) {
                singleton.add(key);
            }
            return singleton;
        }

        @Override
        public CollectionWrapper subCollection(Comparable[] from, boolean fromInclusive, Comparable[] to, boolean toInclusive) {
            return new SetWrapper(this.subSet(from, to));
        }
    }

    class CacheWrapper
    implements CollectionWrapper {
        private final TxVersionedCache cache;
        private int rowsAffected = 0;

        public CacheWrapper(VersionedCache cache) {
            this(new TxVersionedCache(cache));
        }

        protected CacheWrapper(TxVersionedCache cache) {
            this.cache = cache;
        }

        @Override
        public int size() {
            return this.rowsAffected;
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            Pair<Comparable[], Comparable[]> keyValue = Table.this.toKeyValue(o);
            return this.cache.get((Comparable[])keyValue.left) != null;
        }

        @Override
        public Iterator iterator() {
            return Iterators.transform(this.cache.all(), Table.this::toRow);
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray(Object[] a) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object o) {
            if (o.getClass().isArray() && ((Object[])o).length != Table.this.size()) {
                return this.update(o);
            }
            return this.insert(o);
        }

        private boolean insert(Object o) {
            Pair<Comparable[], Comparable[]> keyValue = Table.this.toKeyValue(o);
            this.cache.put((Comparable[])keyValue.left, (Comparable[])keyValue.right);
            ++this.rowsAffected;
            return true;
        }

        private boolean update(Object o) {
            Pair<Comparable[], Comparable[]> keyValue = Table.this.toKeyValue(o);
            Comparable[] oldKey = (Comparable[])Arrays.copyOf((Object[])keyValue.left, ((Comparable[])keyValue.left).length);
            Comparable[] oldValue = (Comparable[])Arrays.copyOf((Object[])keyValue.right, ((Comparable[])keyValue.right).length);
            int fieldCount = Table.this.size();
            Object[] values = (Object[])o;
            int len = (values.length - fieldCount) / 2;
            Object[] putValues = Arrays.copyOfRange(values, fieldCount, fieldCount + len);
            Object[] colValues = Arrays.copyOfRange(values, fieldCount + len, values.length);
            int[] inverseIndices = Table.this.getInverseIndices();
            int keySize = Table.this.getRelDef().getKeyFields().size();
            for (int i = 0; i < putValues.length; ++i) {
                Object colValue = putValues[i];
                String colName = colValues[i].toString();
                int fieldIndex = Table.this.getRelDef().getRowType().getField(colName, true, false).getIndex();
                int inverseIndex = inverseIndices[fieldIndex];
                if (inverseIndex < keySize) {
                    ((Comparable[])keyValue.left)[inverseIndex] = (Comparable)colValue;
                    continue;
                }
                ((Comparable[])keyValue.right)[inverseIndex - keySize] = (Comparable)colValue;
            }
            boolean replaced = this.cache.replace(oldKey, oldValue, (Comparable[])keyValue.left, (Comparable[])keyValue.right);
            if (replaced) {
                ++this.rowsAffected;
            }
            return replaced;
        }

        @Override
        public boolean remove(Object o) {
            Pair<Comparable[], Comparable[]> keyValue = Table.this.toKeyValue(o);
            this.cache.remove((Comparable[])keyValue.left);
            ++this.rowsAffected;
            return true;
        }

        public boolean containsAll(Collection c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection c) {
            for (Object o : c) {
                this.add(o);
            }
            return true;
        }

        public boolean removeAll(Collection c) {
            for (Object o : c) {
                this.remove(o);
            }
            return true;
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CollectionWrapper singleton(Comparable[] key) {
            SetWrapper singleton = new SetWrapper();
            VersionedValue value = this.cache.get(key);
            if (value != null) {
                Comparable[] row = Table.this.toRow((KeyValue<Comparable[], VersionedValue>)new KeyValue((Object)key, (Object)value));
                if (!row.getClass().isArray()) {
                    row = new Comparable[]{(Comparable)row};
                }
                singleton.add(row);
            }
            return singleton;
        }

        @Override
        public CollectionWrapper subCollection(Comparable[] from, boolean fromInclusive, Comparable[] to, boolean toInclusive) {
            return new CacheWrapper(this.cache.subCache(from, fromInclusive, to, toInclusive));
        }
    }

    static interface CollectionWrapper
    extends Collection {
        public CollectionWrapper singleton(Comparable[] var1);

        public CollectionWrapper subCollection(Comparable[] var1, boolean var2, Comparable[] var3, boolean var4);
    }

    public static class ComparableArrayComparator
    implements Comparator<Comparable[]> {
        private final Comparator<Comparable> defaultComparator = Comparator.nullsFirst(Comparator.naturalOrder());

        @Override
        public int compare(Comparable[] o1, Comparable[] o2) {
            for (int i = 0; i < Math.min(o1.length, o2.length); ++i) {
                int c = this.defaultComparator.compare(o1[i], o2[i]);
                if (c == 0) continue;
                return c;
            }
            return Integer.compare(o1.length, o2.length);
        }
    }
}

