/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.schema;

import io.kareldb.schema.ColumnDef;
import io.kareldb.schema.ColumnStrategy;
import io.kareldb.schema.ColumnType;
import io.kareldb.schema.RelDef;
import io.kareldb.schema.Table;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.ddl.SqlAlterTableExtension;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.kafka.common.Configurable;

public abstract class Schema
extends AbstractSchema
implements Configurable,
Closeable {
    private Map<String, Object> configs;

    public void configure(Map<String, ?> configs) {
        this.configs = configs;
    }

    public abstract void init();

    public abstract void sync();

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public abstract Map<String, org.apache.calcite.schema.Table> getTableMap();

    public abstract Table createTable(String var1, Map<String, Object> var2, RelDef var3);

    public abstract void alterTable(String var1, List<SqlAlterTableExtension.Action> var2, RelDef var3);

    public abstract boolean dropTable(String var1);

    public static RelDef toRowType(LinkedHashMap<String, ColumnDef> columnTypes, List<String> keyFields) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (ColumnDef columnDef : columnTypes.values()) {
            RelDataType type = columnDef == null ? typeFactory.createSqlType(SqlTypeName.VARCHAR) : columnDef.toType((JavaTypeFactory)typeFactory);
            types.add(type);
        }
        RelDataType rowType = typeFactory.createStructType(Pair.zip(new ArrayList<String>(columnTypes.keySet()), types));
        List<ColumnStrategy> strategies = columnTypes.values().stream().map(ColumnDef::getColumnStrategy).collect(Collectors.toList());
        return new RelDef(rowType, keyFields, strategies);
    }

    public static LinkedHashMap<String, ColumnDef> toColumnDefs(RelDataType rowType) {
        LinkedHashMap<String, ColumnDef> columnDefs = new LinkedHashMap<String, ColumnDef>();
        for (RelDataTypeField field : rowType.getFieldList()) {
            columnDefs.put(field.getName(), Schema.toColumnDef(field.getType()));
        }
        return columnDefs;
    }

    private static ColumnDef toColumnDef(RelDataType fieldType) {
        SqlTypeName sqlTypeName = fieldType.getSqlTypeName();
        ColumnType columnType = ColumnType.of(sqlTypeName);
        return sqlTypeName == SqlTypeName.DECIMAL ? new ColumnDef(columnType, fieldType.getPrecision(), fieldType.getScale()) : new ColumnDef(columnType);
    }
}

