/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.schema;

import com.google.common.collect.Iterators;
import io.kareldb.schema.ColumnType;
import io.kareldb.schema.RelDef;
import io.kareldb.schema.Schema;
import io.kareldb.schema.Table;
import io.kareldb.schema.TableEnumerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;

public abstract class FilterableTable
extends Table
implements org.apache.calcite.schema.FilterableTable {
    public FilterableTable(Schema schema, String name, RelDef rowType) {
        super(schema, name, rowType);
    }

    public String toString() {
        return "FilterableTable";
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters) {
        Table.CollectionWrapper rows = (Table.CollectionWrapper)this.getModifiableCollection();
        for (RexNode filter : filters) {
            rows = this.scanFilterForKeyFields(root, filter, rows);
        }
        final Table.CollectionWrapper coll = rows;
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new TableEnumerator<Object[]>(Iterators.transform(coll.iterator(), Table::toArray), cancelFlag, true);
            }
        };
    }

    private Table.CollectionWrapper scanFilterForKeyFields(DataContext root, RexNode filter, Table.CollectionWrapper rows) {
        Comparable[] keyValues = this.findKeyFieldAccess(root, filter, SqlKind.EQUALS);
        if (keyValues != null) {
            return rows.singleton(keyValues);
        }
        boolean fromInclusive = false;
        Comparable[] rangeMin = this.findKeyFieldAccess(root, filter, SqlKind.GREATER_THAN_OR_EQUAL);
        if (rangeMin == null) {
            rangeMin = this.findKeyFieldAccess(root, filter, SqlKind.GREATER_THAN);
        } else {
            fromInclusive = true;
        }
        boolean toInclusive = false;
        Comparable[] rangeMax = this.findKeyFieldAccess(root, filter, SqlKind.LESS_THAN_OR_EQUAL);
        if (rangeMax == null) {
            rangeMax = this.findKeyFieldAccess(root, filter, SqlKind.LESS_THAN);
        } else {
            toInclusive = true;
        }
        if (rangeMin != null || rangeMax != null) {
            return rows.subCollection(rangeMin, fromInclusive, rangeMax, toInclusive);
        }
        return rows;
    }

    private Comparable[] findKeyFieldAccess(DataContext root, RexNode filter, SqlKind operator) {
        int[] keyIndices = this.getKeyIndices();
        List<String> keyFields = this.getRelDef().getKeyFields();
        Comparable[] keyValues = new Comparable[keyIndices.length];
        for (int i = 0; i < keyIndices.length; ++i) {
            int keyIndex = keyIndices[i];
            String keyField = keyFields.get(i);
            ColumnType type = ColumnType.of(this.getRowType().getField(keyField, true, false).getType().getSqlTypeName());
            List<Comparable> values = this.scanFilterForKeyField(root, filter, keyIndex, operator, type);
            if (values.isEmpty()) {
                return null;
            }
            keyValues[i] = values.get(0);
        }
        return keyValues;
    }

    private List<Comparable> scanFilterForKeyField(DataContext root, RexNode filter, int keyIndex, SqlKind operator, ColumnType type) {
        ArrayList<Comparable> values = new ArrayList<Comparable>();
        if (filter.isA(SqlKind.AND)) {
            ((RexCall)filter).getOperands().forEach(subFilter -> values.addAll(this.scanFilterForKeyField(root, (RexNode)subFilter, keyIndex, operator, type)));
        } else if (filter.isA(operator)) {
            RexCall call = (RexCall)filter;
            RexNode left = (RexNode)call.getOperands().get(0);
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).operands.get(0);
            }
            RexNode right = (RexNode)call.getOperands().get(1);
            if (left instanceof RexInputRef) {
                if (right instanceof RexLiteral) {
                    int index = ((RexInputRef)left).getIndex();
                    if (index == keyIndex) {
                        Comparable value = (Comparable)((RexLiteral)right).getValueAs(type.getType());
                        return Collections.singletonList(value);
                    }
                } else if (right instanceof RexDynamicParam) {
                    Comparable value = (Comparable)root.get(((RexDynamicParam)right).getName());
                    return Collections.singletonList(value);
                }
            }
        }
        return values;
    }
}

