/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.schema;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;

public enum ColumnType {
    BOOLEAN(Primitive.BOOLEAN, SqlTypeName.BOOLEAN),
    INT(Primitive.INT, SqlTypeName.INTEGER),
    LONG(Primitive.LONG, SqlTypeName.BIGINT),
    FLOAT(Primitive.FLOAT, SqlTypeName.REAL),
    DOUBLE(Primitive.DOUBLE, SqlTypeName.DOUBLE),
    BYTES(byte[].class, "bytes", SqlTypeName.VARBINARY),
    STRING(String.class, "string", SqlTypeName.VARCHAR),
    DECIMAL(BigDecimal.class, "decimal", SqlTypeName.DECIMAL),
    DATE(Date.class, "date", SqlTypeName.DATE),
    TIME(Time.class, "time", SqlTypeName.TIME),
    TIMESTAMP(Timestamp.class, "timestamp", SqlTypeName.TIMESTAMP);

    private final Class clazz;
    private final String simpleName;
    private final SqlTypeName sqlType;
    private static final Map<String, ColumnType> NAMES;
    private static final Map<SqlTypeName, ColumnType> TYPES;

    private ColumnType(Primitive primitive, SqlTypeName sqlType) {
        this(primitive.boxClass, primitive.primitiveName, sqlType);
    }

    private ColumnType(Class clazz, String simpleName, SqlTypeName sqlType) {
        this.clazz = clazz;
        this.simpleName = simpleName;
        this.sqlType = sqlType;
    }

    public Class<?> getType() {
        return this.clazz;
    }

    public SqlTypeName toType(JavaTypeFactory typeFactory) {
        RelDataType javaType = typeFactory.createJavaType(this.clazz);
        return javaType.getSqlTypeName();
    }

    public static ColumnType of(String typeString) {
        return NAMES.get(typeString);
    }

    public static ColumnType of(SqlTypeName sqlType) {
        return TYPES.get(sqlType);
    }

    static {
        NAMES = new HashMap<String, ColumnType>();
        TYPES = new HashMap<SqlTypeName, ColumnType>();
        for (ColumnType value : ColumnType.values()) {
            NAMES.put(value.simpleName, value);
            TYPES.put(value.sqlType, value);
        }
        NAMES.put(Integer.class.getSimpleName(), INT);
    }
}

