/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.schema;

public interface ColumnStrategy {
    public static final ColumnStrategy NOT_NULL_STRATEGY = new NotNullStrategy();
    public static final ColumnStrategy NULL_STRATEGY = new NullStrategy();

    public StrategyType getType();

    default public Object getDefaultValue() {
        return null;
    }

    public static class DefaultStrategy
    implements ColumnStrategy {
        private final Object defaultValue;

        public DefaultStrategy(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public StrategyType getType() {
            return StrategyType.DEFAULT;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static class NullStrategy
    implements ColumnStrategy {
        @Override
        public StrategyType getType() {
            return StrategyType.NULL;
        }
    }

    public static class NotNullStrategy
    implements ColumnStrategy {
        @Override
        public StrategyType getType() {
            return StrategyType.NOT_NULL;
        }
    }

    public static enum StrategyType {
        NOT_NULL,
        NULL,
        DEFAULT;

    }
}

