/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.schema;

import io.kareldb.schema.ColumnStrategy;
import io.kareldb.schema.ColumnType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;

public class ColumnDef {
    private final ColumnType columnType;
    private final ColumnStrategy columnStrategy;
    private final int precision;
    private final int scale;

    public ColumnDef(ColumnType columnType) {
        this(columnType, ColumnStrategy.NULL_STRATEGY, 0, 0);
    }

    public ColumnDef(ColumnType columnType, int precision, int scale) {
        this(columnType, ColumnStrategy.NULL_STRATEGY, precision, scale);
    }

    public ColumnDef(ColumnType columnType, ColumnStrategy columnStrategy, int precision, int scale) {
        this.columnType = columnType;
        this.columnStrategy = columnStrategy;
        this.precision = precision;
        this.scale = scale;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public ColumnStrategy getColumnStrategy() {
        return this.columnStrategy;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public RelDataType toType(JavaTypeFactory typeFactory) {
        SqlTypeName sqlTypeName = this.getColumnType().toType(typeFactory);
        RelDataType sqlType = this.columnType == ColumnType.DECIMAL ? typeFactory.createSqlType(sqlTypeName, this.precision, this.scale) : typeFactory.createSqlType(sqlTypeName);
        return typeFactory.createTypeWithNullability(sqlType, true);
    }
}

