/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.kafka.serialization;

import io.kareldb.avro.AvroSchema;
import io.kareldb.kafka.KafkaTable;
import io.kareldb.version.VersionedValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaValueSerializer
implements Serializer<NavigableMap<Long, VersionedValue>> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaValueSerializer.class);
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    private KafkaTable table;
    private Schema avroSchema;
    private int version;
    private DatumWriter<Object> writer;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.table = (KafkaTable)configs.get("table");
        this.avroSchema = (Schema)configs.get("avroSchema");
        this.version = (Integer)configs.get("version");
        this.writer = new GenericDatumWriter(this.avroSchema, KafkaTable.GENERIC);
    }

    public byte[] serialize(String topic, NavigableMap<Long, VersionedValue> object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(this.version).array());
            BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
            this.writer.write(this.toArray(object), (Encoder)encoder);
            encoder.flush();
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error serializing Avro value " + e.getMessage());
            throw new SerializationException("Error serializing Avro value", (Throwable)e);
        }
    }

    private List<GenericRecord> toArray(NavigableMap<Long, VersionedValue> object) {
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        Schema recordSchema = this.avroSchema.getElementType();
        for (VersionedValue versionedValue : object.values()) {
            Comparable[] value = versionedValue.getValue();
            GenericRecordBuilder builder = new GenericRecordBuilder(recordSchema);
            for (Ord field : Ord.zip((List)recordSchema.getFields())) {
                Comparable v;
                if (field.i == 0) {
                    builder.set((Schema.Field)field.e, (Object)versionedValue.getVersion());
                    continue;
                }
                if (field.i == 1) {
                    builder.set((Schema.Field)field.e, (Object)versionedValue.getCommit());
                    continue;
                }
                if (field.i == 2) {
                    builder.set((Schema.Field)field.e, (Object)versionedValue.isDeleted());
                    continue;
                }
                if (versionedValue.isDeleted() || (v = AvroSchema.toAvroValue(((Schema.Field)field.e).schema(), value[field.i - 3])) == null) continue;
                builder.set((Schema.Field)field.e, (Object)v);
            }
            records.add((GenericRecord)builder.build());
        }
        return records;
    }

    public void close() {
    }
}

