/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.kafka.serialization;

import io.kareldb.avro.AvroSchema;
import io.kareldb.avro.AvroUtils;
import io.kareldb.kafka.KafkaSchema;
import io.kareldb.kafka.KafkaSchemaValue;
import io.kareldb.kafka.KafkaTable;
import io.kareldb.version.VersionedValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.calcite.util.Pair;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaValueDeserializer
implements Deserializer<NavigableMap<Long, VersionedValue>> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaValueDeserializer.class);
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    private KafkaTable table;
    private Schema avroSchema;
    private int version;
    private final Map<Integer, DatumReader<GenericArray<GenericRecord>>> readers = new HashMap<Integer, DatumReader<GenericArray<GenericRecord>>>();

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.table = (KafkaTable)configs.get("table");
        this.avroSchema = (Schema)configs.get("avroSchema");
        this.version = (Integer)configs.get("version");
    }

    public NavigableMap<Long, VersionedValue> deserialize(String topic, byte[] payload) throws SerializationException {
        if (payload == null) {
            return null;
        }
        try {
            ByteBuffer buffer = this.getByteBuffer(payload);
            int version = buffer.getInt();
            int length = buffer.limit() - 1 - 4;
            int start = buffer.position() + buffer.arrayOffset();
            GenericDatumReader reader = this.readers.get(version);
            if (reader == null) {
                KafkaSchema schema = (KafkaSchema)this.table.getSchema();
                KafkaSchemaValue schemaValue = schema.getSchemaValue(this.table.getName(), version);
                Schema writerSchema = AvroUtils.parseSchema(schemaValue.getSchema());
                Pair<Schema, Schema> schemas = KafkaTable.getKeyValueSchemas(writerSchema);
                Schema valueSchema = (Schema)schemas.right;
                reader = new GenericDatumReader(valueSchema, this.avroSchema, KafkaTable.GENERIC);
                this.readers.put(version, (DatumReader<GenericArray<GenericRecord>>)reader);
            }
            GenericArray array = (GenericArray)reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(buffer.array(), start, length, null));
            return this.toValue((GenericArray<GenericRecord>)array);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error deserializing Avro value " + e.getMessage());
            throw new SerializationException("Error deserializing Avro value", (Throwable)e);
        }
    }

    private ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    private NavigableMap<Long, VersionedValue> toValue(GenericArray<GenericRecord> array) {
        TreeMap<Long, VersionedValue> map = new TreeMap<Long, VersionedValue>();
        Schema recordSchema = this.avroSchema.getElementType();
        List fields = recordSchema.getFields();
        int size = fields.size();
        for (GenericRecord record : array) {
            Long version = (Long)record.get(0);
            Long commit = (Long)record.get(1);
            boolean deleted = (Boolean)record.get(2);
            Comparable[] row = new Comparable[size - 3];
            for (int i = 0; i < row.length; ++i) {
                Schema schema = ((Schema.Field)fields.get(i + 3)).schema();
                Comparable value = (Comparable)record.get(i + 3);
                row[i] = AvroSchema.fromAvroValue(schema, value);
            }
            map.put(version, new VersionedValue(version, commit, deleted, row));
        }
        return map;
    }

    public void close() {
    }
}

