/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.kafka.serialization;

import io.kareldb.avro.AvroSchema;
import io.kareldb.kafka.KafkaTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaKeySerializer
implements Serializer<Comparable[]> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaKeySerializer.class);
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    private Schema avroSchema;
    private DatumWriter<Object> writer;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.avroSchema = (Schema)configs.get("avroSchema");
        this.writer = new GenericDatumWriter(this.avroSchema, KafkaTable.GENERIC);
    }

    public byte[] serialize(String topic, Comparable[] object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
            this.writer.write((Object)this.toRecord(object), (Encoder)encoder);
            encoder.flush();
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error serializing Avro key " + e.getMessage());
            throw new SerializationException("Error serializing Avro key", (Throwable)e);
        }
    }

    private GenericRecord toRecord(Comparable[] object) {
        GenericRecordBuilder builder = new GenericRecordBuilder(this.avroSchema);
        for (Ord field : Ord.zip((List)this.avroSchema.getFields())) {
            Comparable c = object[field.i];
            builder.set((Schema.Field)field.e, (Object)AvroSchema.toAvroValue(((Schema.Field)field.e).schema(), c));
        }
        return builder.build();
    }

    public void close() {
    }
}

