/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.kafka.serialization;

import io.kareldb.avro.AvroSchema;
import io.kareldb.kafka.KafkaTable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaKeyDeserializer
implements Deserializer<Comparable[]> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaKeyDeserializer.class);
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    private Schema avroSchema;
    private DatumReader<GenericRecord> reader;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.avroSchema = (Schema)configs.get("avroSchema");
        this.reader = new GenericDatumReader(this.avroSchema, this.avroSchema, KafkaTable.GENERIC);
    }

    public Comparable[] deserialize(String topic, byte[] payload) throws SerializationException {
        if (payload == null) {
            return null;
        }
        try {
            GenericRecord record = (GenericRecord)this.reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(payload, null));
            return this.toKey(record);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error deserializing Avro key " + e.getMessage());
            throw new SerializationException("Error deserializing Avro key", (Throwable)e);
        }
    }

    private Comparable[] toKey(GenericRecord record) {
        List fields = this.avroSchema.getFields();
        int size = fields.size();
        Comparable[] row = new Comparable[size];
        for (int i = 0; i < size; ++i) {
            Schema schema = ((Schema.Field)fields.get(i)).schema();
            Comparable value = (Comparable)record.get(i);
            row[i] = AvroSchema.fromAvroValue(schema, value);
        }
        return row;
    }

    public void close() {
    }
}

