/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kareldb.kafka.KafkaSchema;
import java.util.Objects;

public class KafkaSchemaValue
implements Comparable<KafkaSchemaValue> {
    private final String tableName;
    private final Integer version;
    private final String schema;
    private final KafkaSchema.Action action;
    private final Integer epoch;

    public KafkaSchemaValue(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="version") Integer version, @JsonProperty(value="schema") String schema, @JsonProperty(value="action") KafkaSchema.Action action, @JsonProperty(value="epoch") Integer epoch) {
        this.tableName = tableName;
        this.version = version;
        this.schema = schema;
        this.action = action;
        this.epoch = epoch;
    }

    @JsonProperty(value="tableName")
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="action")
    public KafkaSchema.Action getAction() {
        return this.action;
    }

    @JsonProperty(value="epoch")
    public Integer getEpoch() {
        return this.epoch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSchemaValue that = (KafkaSchemaValue)o;
        return this.tableName.equals(that.tableName) && this.version.equals(that.version) && Objects.equals(this.schema, that.schema) && this.action == that.action && this.epoch.equals(that.epoch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tableName, this.version, this.schema, this.action, this.epoch});
    }

    public String toString() {
        return "KafkaSchemaValue{tableName='" + this.tableName + '\'' + ", version=" + this.version + ", schema='" + this.schema + '\'' + ", action=" + (Object)((Object)this.action) + ", epoch=" + this.epoch + '}';
    }

    @Override
    public int compareTo(KafkaSchemaValue that) {
        if (this.tableName.compareTo(that.tableName) < 0) {
            return -1;
        }
        if (this.tableName.compareTo(that.tableName) > 0) {
            return 1;
        }
        if (this.version.compareTo(that.version) < 0) {
            return -1;
        }
        if (this.version.compareTo(that.version) > 0) {
            return 1;
        }
        if (this.schema.compareTo(that.schema) < 0) {
            return -1;
        }
        if (this.schema.compareTo(that.schema) > 0) {
            return 1;
        }
        if (this.action.compareTo(that.action) < 0) {
            return -1;
        }
        if (this.action.compareTo(that.action) > 0) {
            return 1;
        }
        if (this.epoch.compareTo(that.epoch) < 0) {
            return -1;
        }
        if (this.epoch.compareTo(that.epoch) > 0) {
            return 1;
        }
        return 0;
    }
}

