/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

@JsonPropertyOrder(value={"keytype", "subject", "version", "magic"})
public class KafkaSchemaKey
implements Comparable<KafkaSchemaKey> {
    private final String tableName;
    private final Integer version;

    public KafkaSchemaKey(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="version") int version) {
        this.tableName = tableName;
        this.version = version;
    }

    @JsonProperty(value="tableName")
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSchemaKey kafkaSchemaKey = (KafkaSchemaKey)o;
        return this.tableName.equals(kafkaSchemaKey.tableName) && this.version.equals(kafkaSchemaKey.version);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.version);
    }

    public String toString() {
        return "SchemaKey{tableName='" + this.tableName + '\'' + ", version=" + this.version + '}';
    }

    @Override
    public int compareTo(KafkaSchemaKey that) {
        if (this.tableName.compareTo(that.tableName) < 0) {
            return -1;
        }
        if (this.tableName.compareTo(that.tableName) > 0) {
            return 1;
        }
        if (this.version.compareTo(that.version) < 0) {
            return -1;
        }
        if (this.version.compareTo(that.version) > 0) {
            return 1;
        }
        return 0;
    }
}

