/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc.rules;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableTableModify;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.util.BuiltInMethod;

public class EnumerableTableModifyExtension
extends EnumerableTableModify {
    public EnumerableTableModifyExtension(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traits, table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableTableModifyExtension(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), (RelNode)EnumerableTableModifyExtension.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Method method;
        Expression convertedChildExp;
        PhysType physType;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result result = implementor.visitChild((EnumerableRel)this, 0, (EnumerableRel)this.getInput(), pref);
        Expression childExp = builder.append("child", result.block);
        ParameterExpression collectionParameter = Expressions.parameter(Collection.class, (String)builder.newName("collection"));
        Expression expression = this.table.getExpression(ModifiableTable.class);
        assert (expression != null);
        assert (ModifiableTable.class.isAssignableFrom(Types.toClass((Type)expression.getType()))) : expression.getType();
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)collectionParameter, (Expression)Expressions.call((Expression)expression, (Method)BuiltInMethod.MODIFIABLE_TABLE_GET_MODIFIABLE_COLLECTION.method, (Expression[])new Expression[0])));
        Expression countParameter = builder.append("count", (Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), false);
        if (!this.getInput().getRowType().equals(this.getRowType())) {
            JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
            JavaRowFormat format = EnumerableTableScan.deduceFormat((RelOptTable)this.table);
            physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)this.table.getRowType(), (JavaRowFormat)format);
            ArrayList<Object> expressionList = new ArrayList<Object>();
            PhysType childPhysType = result.physType;
            ParameterExpression o_ = Expressions.parameter((Type)childPhysType.getJavaRowType(), (String)"o");
            int fieldCount = childPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                expressionList.add(childPhysType.fieldReference((Expression)o_, i, physType.getJavaFieldType(i)));
            }
            if (this.getOperation() == TableModify.Operation.UPDATE) {
                for (String target : this.getUpdateColumnList()) {
                    ConstantExpression expression1 = new ConstantExpression(String.class, (Object)target);
                    expressionList.add(expression1);
                }
            }
            convertedChildExp = builder.append("convertedChild", (Expression)Expressions.call((Expression)childExp, (Method)BuiltInMethod.SELECT.method, (Expression[])new Expression[]{Expressions.lambda((Expression)physType.record(expressionList), (ParameterExpression[])new ParameterExpression[]{o_})}));
        } else {
            convertedChildExp = childExp;
        }
        switch (this.getOperation()) {
            case INSERT: 
            case UPDATE: {
                method = BuiltInMethod.INTO.method;
                break;
            }
            case DELETE: {
                method = BuiltInMethod.REMOVE_ALL.method;
                break;
            }
            default: {
                throw new AssertionError(this.getOperation());
            }
        }
        builder.add(Expressions.statement((Expression)Expressions.call((Expression)convertedChildExp, (Method)method, (Expression[])new Expression[]{collectionParameter})));
        Expression updatedCountParameter = builder.append("updatedCount", (Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), false);
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)Expressions.condition((Expression)Expressions.greaterThanOrEqual((Expression)updatedCountParameter, (Expression)countParameter), (Expression)Expressions.subtract((Expression)updatedCountParameter, (Expression)countParameter), (Expression)Expressions.subtract((Expression)countParameter, (Expression)updatedCountParameter)), Long.TYPE)})));
        physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)(pref == EnumerableRel.Prefer.ARRAY ? JavaRowFormat.ARRAY : JavaRowFormat.SCALAR));
        return implementor.result(physType, builder.toBlock());
    }
}

